"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClsServiceManager = void 0;
const cls_service_globals_1 = require("./cls-service.globals");
const proxy_provider_manager_1 = require("./proxy-provider/proxy-provider-manager");
class ClsServiceManager {
    /**
     * Retrieve a ClsService outside of Nest's DI.
     * @returns the ClsService
     */
    static getClsService() {
        const cls = this.clsService;
        return cls;
    }
    /**
     * @deprecated use `resolveProxyProviders` on the `ClsService` instance
     */
    static async resolveProxyProviders() {
        return await proxy_provider_manager_1.ProxyProviderManager.resolveProxyProviders();
    }
}
exports.ClsServiceManager = ClsServiceManager;
ClsServiceManager.clsService = cls_service_globals_1.globalClsService;
//# sourceMappingURL=cls-service-manager.js.map