import { Type } from '@nestjs/common';
import { UnknownDependenciesException } from '@nestjs/core/errors/exceptions/unknown-dependencies.exception';
export declare class ProxyProviderError extends Error {
    name: string;
}
export declare class UnknownProxyDependenciesException extends ProxyProviderError {
    static create(error: UnknownDependenciesException, Provider: Type): UnknownProxyDependenciesException;
    private static extractDependencyParams;
    private static composeMessage;
}
export declare class ProxyProviderNotDecoratedException extends ProxyProviderError {
    static create(Provider: Type): ProxyProviderNotDecoratedException;
}
export declare class ProxyProviderNotRegisteredException extends ProxyProviderError {
    static create(providerSymbol: symbol): ProxyProviderNotRegisteredException;
}
export declare class ProxyProviderNotResolvedException extends ProxyProviderError {
    static create(providerSymbol: symbol | string, propName?: string): ProxyProviderNotResolvedException;
    private static formatEnableOptionName;
}
export declare class ProxyProvidersResolutionTimeoutException extends ProxyProviderError {
    static create(timeout: number): ProxyProvidersResolutionTimeoutException;
}
//# sourceMappingURL=proxy-provider.exceptions.d.ts.map