"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.copyMethodMetadata = copyMethodMetadata;
/**
 * Copies all metadata from one object to another.
 * Useful for overwriting function definition in
 * decorators while keeping all previously
 * attached metadata
 *
 * @param from object to copy metadata from
 * @param to object to copy metadata to
 */
function copyMethodMetadata(from, to) {
    const metadataKeys = Reflect.getMetadataKeys(from);
    metadataKeys.map((key) => {
        const value = Reflect.getMetadata(key, from);
        Reflect.defineMetadata(key, value, to);
    });
}
//# sourceMappingURL=copy-method-metadata.js.map