"use strict";
// Kudos to Papooch - https://github.com/Papooch/nestjs-cls/blob/2803ce67409c493601cc61a3299e7b47d3869c66/packages/core/src/lib/cls-module/feature-detection.utils.ts
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpAdapterType = void 0;
exports.detectHttpAdapterType = detectHttpAdapterType;
var HttpAdapterType;
(function (HttpAdapterType) {
    HttpAdapterType["EXPRESS"] = "express";
    HttpAdapterType["FASTIFY"] = "fastify";
})(HttpAdapterType || (exports.HttpAdapterType = HttpAdapterType = {}));
function detectHttpAdapterType(httpAdapter) {
    if (httpAdapter.constructor.name === 'FastifyAdapter') {
        return HttpAdapterType.FASTIFY;
    }
    return HttpAdapterType.EXPRESS;
}
