"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DisableOAuthLogin = exports.EnableOAuthLogin = void 0;
const nest_commander_1 = require("nest-commander");
const cli_service_1 = require("../services/cli.service");
let EnableOAuthLogin = class EnableOAuthLogin extends nest_commander_1.CommandRunner {
    service;
    constructor(service) {
        super();
        this.service = service;
    }
    async run() {
        await this.service.enableOAuthLogin();
        console.log('OAuth login has been enabled.');
    }
};
exports.EnableOAuthLogin = EnableOAuthLogin;
exports.EnableOAuthLogin = EnableOAuthLogin = __decorate([
    (0, nest_commander_1.Command)({
        name: 'enable-oauth-login',
        description: 'Enable OAuth login',
    }),
    __metadata("design:paramtypes", [cli_service_1.CliService])
], EnableOAuthLogin);
let DisableOAuthLogin = class DisableOAuthLogin extends nest_commander_1.CommandRunner {
    service;
    constructor(service) {
        super();
        this.service = service;
    }
    async run() {
        await this.service.disableOAuthLogin();
        console.log('OAuth login has been disabled.');
    }
};
exports.DisableOAuthLogin = DisableOAuthLogin;
exports.DisableOAuthLogin = DisableOAuthLogin = __decorate([
    (0, nest_commander_1.Command)({
        name: 'disable-oauth-login',
        description: 'Disable OAuth login',
    }),
    __metadata("design:paramtypes", [cli_service_1.CliService])
], DisableOAuthLogin);
//# sourceMappingURL=oauth-login.js.map