"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaults = void 0;
const schedule_1 = require("@nestjs/schedule");
const enum_1 = require("./enum");
exports.defaults = Object.freeze({
    backup: {
        database: {
            enabled: true,
            cronExpression: schedule_1.CronExpression.EVERY_DAY_AT_2AM,
            keepLastAmount: 14,
        },
    },
    ffmpeg: {
        crf: 23,
        threads: 0,
        preset: 'ultrafast',
        targetVideoCodec: enum_1.VideoCodec.H264,
        acceptedVideoCodecs: [enum_1.VideoCodec.H264],
        targetAudioCodec: enum_1.AudioCodec.Aac,
        acceptedAudioCodecs: [enum_1.AudioCodec.Aac, enum_1.AudioCodec.Mp3, enum_1.AudioCodec.LibOpus],
        acceptedContainers: [enum_1.VideoContainer.Mov, enum_1.VideoContainer.Ogg, enum_1.VideoContainer.Webm],
        targetResolution: '720',
        maxBitrate: '0',
        bframes: -1,
        refs: 0,
        gopSize: 0,
        temporalAQ: false,
        cqMode: enum_1.CQMode.Auto,
        twoPass: false,
        preferredHwDevice: 'auto',
        transcode: enum_1.TranscodePolicy.Required,
        tonemap: enum_1.ToneMapping.Hable,
        accel: enum_1.TranscodeHardwareAcceleration.Disabled,
        accelDecode: false,
    },
    job: {
        [enum_1.QueueName.BackgroundTask]: { concurrency: 5 },
        [enum_1.QueueName.SmartSearch]: { concurrency: 2 },
        [enum_1.QueueName.MetadataExtraction]: { concurrency: 5 },
        [enum_1.QueueName.FaceDetection]: { concurrency: 2 },
        [enum_1.QueueName.Search]: { concurrency: 5 },
        [enum_1.QueueName.Sidecar]: { concurrency: 5 },
        [enum_1.QueueName.Library]: { concurrency: 5 },
        [enum_1.QueueName.Migration]: { concurrency: 5 },
        [enum_1.QueueName.ThumbnailGeneration]: { concurrency: 3 },
        [enum_1.QueueName.VideoConversion]: { concurrency: 1 },
        [enum_1.QueueName.Notification]: { concurrency: 5 },
        [enum_1.QueueName.Ocr]: { concurrency: 1 },
        [enum_1.QueueName.Workflow]: { concurrency: 5 },
    },
    logging: {
        enabled: true,
        level: enum_1.LogLevel.Log,
    },
    machineLearning: {
        enabled: process.env.IMMICH_MACHINE_LEARNING_ENABLED !== 'false',
        urls: [process.env.IMMICH_MACHINE_LEARNING_URL || 'http://immich-machine-learning:3003'],
        availabilityChecks: {
            enabled: true,
            timeout: Number(process.env.IMMICH_MACHINE_LEARNING_PING_TIMEOUT) || 2000,
            interval: 30_000,
        },
        clip: {
            enabled: true,
            modelName: 'ViT-B-32__openai',
        },
        duplicateDetection: {
            enabled: true,
            maxDistance: 0.01,
        },
        facialRecognition: {
            enabled: true,
            modelName: 'buffalo_l',
            minScore: 0.7,
            maxDistance: 0.5,
            minFaces: 3,
        },
        ocr: {
            enabled: true,
            modelName: 'PP-OCRv5_mobile',
            minDetectionScore: 0.5,
            minRecognitionScore: 0.8,
            maxResolution: 736,
        },
    },
    map: {
        enabled: true,
        lightStyle: 'https://tiles.immich.cloud/v1/style/light.json',
        darkStyle: 'https://tiles.immich.cloud/v1/style/dark.json',
    },
    reverseGeocoding: {
        enabled: true,
    },
    metadata: {
        faces: {
            import: false,
        },
    },
    oauth: {
        autoLaunch: false,
        autoRegister: true,
        buttonText: 'Login with OAuth',
        clientId: '',
        clientSecret: '',
        defaultStorageQuota: null,
        enabled: false,
        issuerUrl: '',
        mobileOverrideEnabled: false,
        mobileRedirectUri: '',
        scope: 'openid email profile',
        signingAlgorithm: 'RS256',
        profileSigningAlgorithm: 'none',
        storageLabelClaim: 'preferred_username',
        storageQuotaClaim: 'immich_quota',
        roleClaim: 'immich_role',
        tokenEndpointAuthMethod: enum_1.OAuthTokenEndpointAuthMethod.ClientSecretPost,
        timeout: 30_000,
    },
    passwordLogin: {
        enabled: true,
    },
    storageTemplate: {
        enabled: false,
        hashVerificationEnabled: true,
        template: '{{y}}/{{y}}-{{MM}}-{{dd}}/{{filename}}',
    },
    image: {
        thumbnail: {
            format: enum_1.ImageFormat.Webp,
            size: 250,
            quality: 80,
        },
        preview: {
            format: enum_1.ImageFormat.Jpeg,
            size: 1440,
            quality: 80,
        },
        colorspace: enum_1.Colorspace.P3,
        extractEmbedded: false,
        fullsize: {
            enabled: false,
            format: enum_1.ImageFormat.Jpeg,
            quality: 80,
        },
    },
    newVersionCheck: {
        enabled: true,
    },
    nightlyTasks: {
        startTime: '00:00',
        databaseCleanup: true,
        generateMemories: true,
        syncQuotaUsage: true,
        missingThumbnails: true,
        clusterNewFaces: true,
    },
    trash: {
        enabled: true,
        days: 30,
    },
    theme: {
        customCss: '',
    },
    library: {
        scan: {
            enabled: true,
            cronExpression: schedule_1.CronExpression.EVERY_DAY_AT_MIDNIGHT,
        },
        watch: {
            enabled: false,
        },
    },
    server: {
        externalDomain: '',
        loginPageMessage: '',
        publicUsers: true,
    },
    notifications: {
        smtp: {
            enabled: false,
            from: '',
            replyTo: '',
            transport: {
                ignoreCert: false,
                host: '',
                port: 587,
                secure: false,
                username: '',
                password: '',
            },
        },
    },
    templates: {
        email: {
            welcomeTemplate: '',
            albumInviteTemplate: '',
            albumUpdateTemplate: '',
        },
    },
    user: {
        deleteDelay: 7,
    },
});
//# sourceMappingURL=config.js.map