"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const job_dto_1 = require("../dtos/job.dto");
const queue_dto_1 = require("../dtos/queue.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const job_service_1 = require("../services/job.service");
const queue_service_1 = require("../services/queue.service");
let JobController = class JobController {
    service;
    queueService;
    constructor(service, queueService) {
        this.service = service;
        this.queueService = queueService;
    }
    getQueuesLegacy() {
        return this.queueService.getAll();
    }
    createJob(dto) {
        return this.service.create(dto);
    }
    runQueueCommandLegacy({ name }, dto) {
        return this.queueService.runCommand(name, dto);
    }
};
exports.JobController = JobController;
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.JobRead, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve queue counts and status',
        description: 'Retrieve the counts of the current queue, as well as the current status.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/queue.dto").QueuesResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], JobController.prototype, "getQueuesLegacy", null);
__decorate([
    (0, common_1.Post)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.JobCreate, admin: true }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    (0, decorators_1.Endpoint)({
        summary: 'Create a manual job',
        description: 'Run a specific job. Most jobs are queued automatically, but this endpoint allows for manual creation of a handful of jobs, including various cleanup tasks, as well as creating a new database backup.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [job_dto_1.JobCreateDto]),
    __metadata("design:returntype", Promise)
], JobController.prototype, "createJob", null);
__decorate([
    (0, common_1.Put)(':name'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.JobCreate, admin: true }),
    (0, decorators_1.Endpoint)({
        summary: 'Run jobs',
        description: 'Queue all assets for a specific job type. Defaults to only queueing assets that have not yet been processed, but the force command can be used to re-process all assets.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/queue.dto").QueueResponseDto }),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [queue_dto_1.QueueNameParamDto, queue_dto_1.QueueCommandDto]),
    __metadata("design:returntype", Promise)
], JobController.prototype, "runQueueCommandLegacy", null);
exports.JobController = JobController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.Jobs),
    (0, common_1.Controller)('jobs'),
    __metadata("design:paramtypes", [job_service_1.JobService,
        queue_service_1.QueueService])
], JobController);
//# sourceMappingURL=job.controller.js.map