import { ApiOperationOptions, ApiPropertyOptions } from '@nestjs/swagger';
import { ApiCustomExtension, ImmichWorker, JobName, MetadataKey, QueueName } from 'src/enum';
import { EmitEvent } from 'src/repositories/event.repository';
import { ColumnOptions } from 'src/sql-tools';
export declare const UpdateIdColumn: (options?: Omit<ColumnOptions, "type" | "default" | "nullable">) => PropertyDecorator;
export declare const CreateIdColumn: (options?: Omit<ColumnOptions, "type" | "default" | "nullable">) => PropertyDecorator;
export declare const PrimaryGeneratedUuidV7Column: () => PropertyDecorator;
export declare const UpdatedAtTrigger: (name: string) => ClassDecorator;
export declare const DATABASE_PARAMETER_CHUNK_SIZE = 65500;
export declare function Chunked(options?: {
    paramIndex?: number;
    chunkSize?: number;
    mergeFn?: (results: any) => any;
}): MethodDecorator;
export declare function ChunkedArray(options?: {
    paramIndex?: number;
}): MethodDecorator;
export declare function ChunkedSet(options?: {
    paramIndex?: number;
}): MethodDecorator;
export declare const DummyValue: {
    UUID: string;
    UUID_SET: Set<string>;
    PAGINATION: {
        take: number;
        skip: number;
    };
    EMAIL: string;
    STRING: string;
    NUMBER: number;
    BUFFER: Buffer<ArrayBuffer>;
    DATE: Date;
    TIME_BUCKET: string;
    BOOLEAN: boolean;
    VECTOR: string;
};
export declare const GENERATE_SQL_KEY = "generate-sql-key";
export interface GenerateSqlQueries {
    name?: string;
    params: unknown[];
    stream?: boolean;
}
export declare const Telemetry: (options: {
    enabled?: boolean;
}) => import("@nestjs/common").CustomDecorator<MetadataKey>;
export declare const GenerateSql: (...options: GenerateSqlQueries[]) => import("@nestjs/common").CustomDecorator<string>;
export type EventConfig = {
    name: EmitEvent;
    server?: boolean;
    priority?: number;
    workers?: ImmichWorker[];
};
export declare const OnEvent: (config: EventConfig) => import("@nestjs/common").CustomDecorator<MetadataKey>;
export type JobConfig = {
    name: JobName;
    queue: QueueName;
};
export declare const OnJob: (config: JobConfig) => import("@nestjs/common").CustomDecorator<MetadataKey>;
type EndpointOptions = ApiOperationOptions & {
    history?: HistoryBuilder;
};
export declare const Endpoint: ({ history, ...options }: EndpointOptions) => <TFunction extends Function, Y>(target: TFunction | object, propertyKey?: string | symbol, descriptor?: TypedPropertyDescriptor<Y>) => void;
type PropertyOptions = ApiPropertyOptions & {
    history?: HistoryBuilder;
};
export declare const Property: ({ history, ...options }: PropertyOptions) => PropertyDecorator;
type HistoryEntry = {
    version: string;
    state: ApiState | 'Added' | 'Updated';
    description?: string;
    replacementId?: string;
};
type DeprecatedOptions = {
    replacementId?: string;
};
type CustomExtensions = {
    [ApiCustomExtension.State]?: ApiState;
    [ApiCustomExtension.History]?: HistoryEntry[];
};
declare enum ApiState {
    'Stable' = "Stable",
    'Alpha' = "Alpha",
    'Beta' = "Beta",
    'Internal' = "Internal",
    'Deprecated' = "Deprecated"
}
export declare class HistoryBuilder {
    private hasDeprecated;
    private items;
    added(version: string, description?: string): this;
    updated(version: string, description: string): this;
    alpha(version: string): this;
    beta(version: string): this;
    internal(version: string): this;
    stable(version: string): this;
    deprecated(version: string, options?: DeprecatedOptions): this;
    isDeprecated(): boolean;
    getExtensions(): CustomExtensions;
    private push;
}
export {};
