export declare enum AssetMediaStatus {
    CREATED = "created",
    REPLACED = "replaced",
    DUPLICATE = "duplicate"
}
export declare class AssetMediaResponseDto {
    status: AssetMediaStatus;
    id: string;
}
export declare enum AssetUploadAction {
    ACCEPT = "accept",
    REJECT = "reject"
}
export declare enum AssetRejectReason {
    DUPLICATE = "duplicate",
    UNSUPPORTED_FORMAT = "unsupported-format"
}
export declare class AssetBulkUploadCheckResult {
    id: string;
    action: AssetUploadAction;
    reason?: AssetRejectReason;
    assetId?: string;
    isTrashed?: boolean;
}
export declare class AssetBulkUploadCheckResponseDto {
    results: AssetBulkUploadCheckResult[];
}
export declare class CheckExistingAssetsResponseDto {
    existingIds: string[];
}
