"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PluginManifestDto = void 0;
const openapi = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class PluginManifestWasmDto {
    path;
    static _OPENAPI_METADATA_FACTORY() {
        return { path: { required: true, type: () => String } };
    }
}
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], PluginManifestWasmDto.prototype, "path", void 0);
class PluginManifestFilterDto {
    methodName;
    title;
    description;
    supportedContexts;
    schema;
    static _OPENAPI_METADATA_FACTORY() {
        return { methodName: { required: true, type: () => String }, title: { required: true, type: () => String }, description: { required: true, type: () => String }, supportedContexts: { required: true, enum: require("../enum").PluginContext, isArray: true, minItems: 1 }, schema: { required: false, type: () => Object } };
    }
}
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], PluginManifestFilterDto.prototype, "methodName", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], PluginManifestFilterDto.prototype, "title", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], PluginManifestFilterDto.prototype, "description", void 0);
__decorate([
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ArrayMinSize)(1),
    (0, class_validator_1.IsEnum)(enum_1.PluginContext, { each: true }),
    __metadata("design:type", Array)
], PluginManifestFilterDto.prototype, "supportedContexts", void 0);
__decorate([
    (0, class_validator_1.IsObject)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Object)
], PluginManifestFilterDto.prototype, "schema", void 0);
class PluginManifestActionDto {
    methodName;
    title;
    description;
    supportedContexts;
    schema;
    static _OPENAPI_METADATA_FACTORY() {
        return { methodName: { required: true, type: () => String }, title: { required: true, type: () => String }, description: { required: true, type: () => String }, supportedContexts: { required: true, enum: require("../enum").PluginContext, isArray: true, minItems: 1 }, schema: { required: false, type: () => Object } };
    }
}
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], PluginManifestActionDto.prototype, "methodName", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], PluginManifestActionDto.prototype, "title", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], PluginManifestActionDto.prototype, "description", void 0);
__decorate([
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ArrayMinSize)(1),
    (0, validation_1.ValidateEnum)({ enum: enum_1.PluginContext, name: 'PluginContext', each: true }),
    __metadata("design:type", Array)
], PluginManifestActionDto.prototype, "supportedContexts", void 0);
__decorate([
    (0, class_validator_1.IsObject)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Object)
], PluginManifestActionDto.prototype, "schema", void 0);
class PluginManifestDto {
    name;
    version;
    title;
    description;
    author;
    wasm;
    filters;
    actions;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: true, type: () => String, pattern: "/^[a-z0-9-]+[a-z0-9]$/" }, version: { required: true, type: () => String }, title: { required: true, type: () => String }, description: { required: true, type: () => String }, author: { required: true, type: () => String }, wasm: { required: true, type: () => PluginManifestWasmDto }, filters: { required: false, type: () => [PluginManifestFilterDto] }, actions: { required: false, type: () => [PluginManifestActionDto] } };
    }
}
exports.PluginManifestDto = PluginManifestDto;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.Matches)(/^[a-z0-9-]+[a-z0-9]$/, {
        message: 'Plugin name must contain only lowercase letters, numbers, and hyphens, and cannot end with a hyphen',
    }),
    __metadata("design:type", String)
], PluginManifestDto.prototype, "name", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsSemVer)(),
    __metadata("design:type", String)
], PluginManifestDto.prototype, "version", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], PluginManifestDto.prototype, "title", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], PluginManifestDto.prototype, "description", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], PluginManifestDto.prototype, "author", void 0);
__decorate([
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => PluginManifestWasmDto),
    __metadata("design:type", PluginManifestWasmDto)
], PluginManifestDto.prototype, "wasm", void 0);
__decorate([
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => PluginManifestFilterDto),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Array)
], PluginManifestDto.prototype, "filters", void 0);
__decorate([
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => PluginManifestActionDto),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Array)
], PluginManifestDto.prototype, "actions", void 0);
//# sourceMappingURL=plugin-manifest.dto.js.map