import { QueueCommand, QueueName } from 'src/enum';
export declare class QueueNameParamDto {
    name: QueueName;
}
export declare class QueueCommandDto {
    command: QueueCommand;
    force?: boolean;
}
export declare class QueueStatisticsDto {
    active: number;
    completed: number;
    failed: number;
    delayed: number;
    waiting: number;
    paused: number;
}
export declare class QueueStatusDto {
    isActive: boolean;
    isPaused: boolean;
}
export declare class QueueResponseDto {
    jobCounts: QueueStatisticsDto;
    queueStatus: QueueStatusDto;
}
export declare class QueuesResponseDto implements Record<QueueName, QueueResponseDto> {
    [QueueName.ThumbnailGeneration]: QueueResponseDto;
    [QueueName.MetadataExtraction]: QueueResponseDto;
    [QueueName.VideoConversion]: QueueResponseDto;
    [QueueName.SmartSearch]: QueueResponseDto;
    [QueueName.StorageTemplateMigration]: QueueResponseDto;
    [QueueName.Migration]: QueueResponseDto;
    [QueueName.BackgroundTask]: QueueResponseDto;
    [QueueName.Search]: QueueResponseDto;
    [QueueName.DuplicateDetection]: QueueResponseDto;
    [QueueName.FaceDetection]: QueueResponseDto;
    [QueueName.FacialRecognition]: QueueResponseDto;
    [QueueName.Sidecar]: QueueResponseDto;
    [QueueName.Library]: QueueResponseDto;
    [QueueName.Notification]: QueueResponseDto;
    [QueueName.BackupDatabase]: QueueResponseDto;
    [QueueName.Ocr]: QueueResponseDto;
    [QueueName.Workflow]: QueueResponseDto;
}
