import { NextFunction, Request, Response } from 'express';
import { IncomingHttpHeaders } from 'node:http';
import { MaintenanceAuthDto } from 'src/dtos/maintenance.dto';
import { MaintenanceWebsocketRepository } from 'src/maintenance/maintenance-websocket.repository';
import { AppRepository } from 'src/repositories/app.repository';
import { ConfigRepository } from 'src/repositories/config.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { SystemMetadataRepository } from 'src/repositories/system-metadata.repository';
export declare class MaintenanceWorkerService {
    protected logger: LoggingRepository;
    private appRepository;
    private configRepository;
    private systemMetadataRepository;
    private maintenanceWorkerRepository;
    constructor(logger: LoggingRepository, appRepository: AppRepository, configRepository: ConfigRepository, systemMetadataRepository: SystemMetadataRepository, maintenanceWorkerRepository: MaintenanceWebsocketRepository);
    private get configRepos();
    private getConfig;
    getSystemConfig(): Promise<{
        loginPageMessage: string;
        trashDays: number;
        userDeleteDelay: number;
        oauthButtonText: string;
        isInitialized: boolean;
        isOnboarded: boolean;
        externalDomain: string;
        publicUsers: boolean;
        mapDarkStyleUrl: string;
        mapLightStyleUrl: string;
        maintenanceMode: boolean;
    }>;
    ssr(excludePaths: string[]): (request: Request, res: Response, next: NextFunction) => void;
    private secret;
    logSecret(): Promise<void>;
    authenticate(headers: IncomingHttpHeaders): Promise<MaintenanceAuthDto>;
    login(jwt?: string): Promise<MaintenanceAuthDto>;
    endMaintenance(): Promise<void>;
}
