import { Insertable, Kysely, Updateable } from 'kysely';
import { DB } from 'src/schema';
import { StackTable } from 'src/schema/tables/stack.table';
export interface StackSearch {
    ownerId: string;
    primaryAssetId?: string;
}
export declare class StackRepository {
    private db;
    constructor(db: Kysely<DB>);
    search(query: StackSearch): Promise<{
        id: string;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        ownerId: string;
        primaryAssetId: string;
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updatedAt: Date;
            updateId: string;
            createdAt: Date;
            deletedAt: Date | null;
            status: import("../enum").AssetStatus;
            ownerId: string;
            isFavorite: boolean;
            stackId: string | null;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            duplicateId: string | null;
            visibility: import("../enum").AssetVisibility;
            tags?: {
                id: string;
                value: string;
                createdAt: Date;
                updatedAt: Date;
                color: string | null;
                parentId: string | null;
            }[] | undefined;
            exifInfo: {
                description: string;
                assetId: string;
                state: string | null;
                fileSizeInByte: number | null;
                make: string | null;
                model: string | null;
                exifImageWidth: number | null;
                exifImageHeight: number | null;
                orientation: string | null;
                dateTimeOriginal: Date | null;
                modifyDate: Date | null;
                lensModel: string | null;
                fNumber: number | null;
                focalLength: number | null;
                iso: number | null;
                latitude: number | null;
                longitude: number | null;
                city: string | null;
                country: string | null;
                fps: number | null;
                exposureTime: string | null;
                livePhotoCID: string | null;
                timeZone: string | null;
                projectionType: string | null;
                profileDescription: string | null;
                colorspace: string | null;
                bitsPerSample: number | null;
                autoStackId: string | null;
                rating: number | null;
            };
        }[];
    }[]>;
    create(entity: Omit<Insertable<StackTable>, 'primaryAssetId'>, assetIds: string[]): Promise<{
        id: string;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        ownerId: string;
        primaryAssetId: string;
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updatedAt: Date;
            updateId: string;
            createdAt: Date;
            deletedAt: Date | null;
            status: import("../enum").AssetStatus;
            ownerId: string;
            isFavorite: boolean;
            stackId: string | null;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            duplicateId: string | null;
            visibility: import("../enum").AssetVisibility;
            tags?: {
                id: string;
                value: string;
                createdAt: Date;
                updatedAt: Date;
                color: string | null;
                parentId: string | null;
            }[] | undefined;
            exifInfo: {
                description: string;
                assetId: string;
                state: string | null;
                fileSizeInByte: number | null;
                make: string | null;
                model: string | null;
                exifImageWidth: number | null;
                exifImageHeight: number | null;
                orientation: string | null;
                dateTimeOriginal: Date | null;
                modifyDate: Date | null;
                lensModel: string | null;
                fNumber: number | null;
                focalLength: number | null;
                iso: number | null;
                latitude: number | null;
                longitude: number | null;
                city: string | null;
                country: string | null;
                fps: number | null;
                exposureTime: string | null;
                livePhotoCID: string | null;
                timeZone: string | null;
                projectionType: string | null;
                profileDescription: string | null;
                colorspace: string | null;
                bitsPerSample: number | null;
                autoStackId: string | null;
                rating: number | null;
            };
        }[];
    }>;
    delete(id: string): Promise<void>;
    deleteAll(ids: string[]): Promise<void>;
    update(id: string, entity: Updateable<StackTable>): Promise<{
        id: string;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        ownerId: string;
        primaryAssetId: string;
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updatedAt: Date;
            updateId: string;
            createdAt: Date;
            deletedAt: Date | null;
            status: import("../enum").AssetStatus;
            ownerId: string;
            isFavorite: boolean;
            stackId: string | null;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            duplicateId: string | null;
            visibility: import("../enum").AssetVisibility;
            tags?: {
                id: string;
                value: string;
                createdAt: Date;
                updatedAt: Date;
                color: string | null;
                parentId: string | null;
            }[] | undefined;
            exifInfo: {
                description: string;
                assetId: string;
                state: string | null;
                fileSizeInByte: number | null;
                make: string | null;
                model: string | null;
                exifImageWidth: number | null;
                exifImageHeight: number | null;
                orientation: string | null;
                dateTimeOriginal: Date | null;
                modifyDate: Date | null;
                lensModel: string | null;
                fNumber: number | null;
                focalLength: number | null;
                iso: number | null;
                latitude: number | null;
                longitude: number | null;
                city: string | null;
                country: string | null;
                fps: number | null;
                exposureTime: string | null;
                livePhotoCID: string | null;
                timeZone: string | null;
                projectionType: string | null;
                profileDescription: string | null;
                colorspace: string | null;
                bitsPerSample: number | null;
                autoStackId: string | null;
                rating: number | null;
            };
        }[];
    }>;
    getById(id: string): Promise<{
        id: string;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        ownerId: string;
        primaryAssetId: string;
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updatedAt: Date;
            updateId: string;
            createdAt: Date;
            deletedAt: Date | null;
            status: import("../enum").AssetStatus;
            ownerId: string;
            isFavorite: boolean;
            stackId: string | null;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            duplicateId: string | null;
            visibility: import("../enum").AssetVisibility;
            tags?: {
                id: string;
                value: string;
                createdAt: Date;
                updatedAt: Date;
                color: string | null;
                parentId: string | null;
            }[] | undefined;
            exifInfo: {
                description: string;
                assetId: string;
                state: string | null;
                fileSizeInByte: number | null;
                make: string | null;
                model: string | null;
                exifImageWidth: number | null;
                exifImageHeight: number | null;
                orientation: string | null;
                dateTimeOriginal: Date | null;
                modifyDate: Date | null;
                lensModel: string | null;
                fNumber: number | null;
                focalLength: number | null;
                iso: number | null;
                latitude: number | null;
                longitude: number | null;
                city: string | null;
                country: string | null;
                fps: number | null;
                exposureTime: string | null;
                livePhotoCID: string | null;
                timeZone: string | null;
                projectionType: string | null;
                profileDescription: string | null;
                colorspace: string | null;
                bitsPerSample: number | null;
                autoStackId: string | null;
                rating: number | null;
            };
        }[];
    } | undefined>;
    getForAssetRemoval(assetId: string): Promise<{
        primaryAssetId: string | null;
        id: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<{
            library: import("../schema/tables/library.table").LibraryTable;
            api_key: import("../schema/tables/api-key.table").ApiKeyTable;
            workflow: import("../schema/tables/workflow.table").WorkflowTable;
            asset: import("../schema/tables/asset.table").AssetTable;
            album: import("../schema/tables/album.table").AlbumTable;
            person: import("../schema/tables/person.table").PersonTable;
            smart_search: import("../schema/tables/smart-search.table").SmartSearchTable;
            face_search: import("../schema/tables/face-search.table").FaceSearchTable;
            user: import("../schema/tables/user.table").UserTable;
            user_metadata_audit: import("../schema/tables/user-metadata-audit.table").UserMetadataAuditTable;
            asset_metadata_audit: import("../schema/tables/asset-metadata-audit.table").AssetMetadataAuditTable;
            asset_face_audit: import("../schema/tables/asset-face-audit.table").AssetFaceAuditTable;
            stack: import("kysely").Nullable<StackTable>;
            album_asset: import("../schema/tables/album-asset.table").AlbumAssetTable;
            activity: import("../schema/tables/activity.table").ActivityTable;
            album_asset_audit: import("../schema/tables/album-asset-audit.table").AlbumAssetAuditTable;
            album_audit: import("../schema/tables/album-audit.table").AlbumAuditTable;
            album_user_audit: import("../schema/tables/album-user-audit.table").AlbumUserAuditTable;
            album_user: import("../schema/tables/album-user.table").AlbumUserTable;
            asset_audit: import("../schema/tables/asset-audit.table").AssetAuditTable;
            asset_exif: import("../schema/tables/asset-exif.table").AssetExifTable;
            asset_file: import("../schema/tables/asset-file.table").AssetFileTable;
            asset_job_status: import("../schema/tables/asset-job-status.table").AssetJobStatusTable;
            asset_metadata: import("../schema/tables/asset-metadata.table").AssetMetadataTable<import("../enum").AssetMetadataKey>;
            asset_ocr: import("../schema/tables/asset-ocr.table").AssetOcrTable;
            audit: import("../schema/tables/audit.table").AuditTable;
            geodata_places: import("../schema/tables/geodata-places.table").GeodataPlacesTable;
            memory: import("../schema/tables/memory.table").MemoryTable;
            memory_asset_audit: import("../schema/tables/memory-asset-audit.table").MemoryAssetAuditTable;
            memory_asset: import("../schema/tables/memory-asset.table").MemoryAssetTable;
            memory_audit: import("../schema/tables/memory-audit.table").MemoryAuditTable;
            move_history: import("../schema/tables/move.table").MoveTable;
            naturalearth_countries: import("../schema/tables/natural-earth-countries.table").NaturalEarthCountriesTable;
            notification: import("../schema/tables/notification.table").NotificationTable;
            ocr_search: import("../schema/tables/ocr-search.table").OcrSearchTable;
            partner_audit: import("../schema/tables/partner-audit.table").PartnerAuditTable;
            partner: import("../schema/tables/partner.table").PartnerTable;
            person_audit: import("../schema/tables/person-audit.table").PersonAuditTable;
            plugin: import("../schema/tables/plugin.table").PluginTable;
            plugin_filter: import("../schema/tables/plugin.table").PluginFilterTable;
            plugin_action: import("../schema/tables/plugin.table").PluginActionTable;
            session: import("../schema/tables/session.table").SessionTable;
            shared_link: import("../schema/tables/shared-link.table").SharedLinkTable;
            shared_link_asset: import("../schema/tables/shared-link-asset.table").SharedLinkAssetTable;
            stack_audit: import("../schema/tables/stack-audit.table").StackAuditTable;
            session_sync_checkpoint: import("../schema/tables/sync-checkpoint.table").SessionSyncCheckpointTable;
            system_metadata: import("../schema/tables/system-metadata.table").SystemMetadataTable<import("../enum").SystemMetadataKey>;
            tag: import("../schema/tables/tag.table").TagTable;
            tag_asset: import("../schema/tables/tag-asset.table").TagAssetTable;
            tag_closure: import("../schema/tables/tag-closure.table").TagClosureTable;
            user_audit: import("../schema/tables/user-audit.table").UserAuditTable;
            user_metadata: import("../schema/tables/user-metadata.table").UserMetadataTable<import("../enum").UserMetadataKey>;
            version_history: import("../schema/tables/version-history.table").VersionHistoryTable;
            workflow_filter: import("../schema/tables/workflow.table").WorkflowFilterTable;
            workflow_action: import("../schema/tables/workflow.table").WorkflowActionTable;
            asset_face: import("../schema/tables/asset-face.table").AssetFaceTable;
            migrations: import("src/schema").Migrations;
        }, "asset" | "stack", "stackId">;
    } | undefined>;
    merge({ sourceId, targetId }: {
        sourceId: string;
        targetId: string;
    }): Promise<import("kysely").UpdateResult[]>;
}
