"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
const logging_repository_1 = require("../../repositories/logging.repository");
const logger = logging_repository_1.LoggingRepository.create('Migrations');
async function up(db) {
    if (process.env.IMMICH_MEDIA_LOCATION) {
        return;
    }
    const source = 'upload';
    const target = '/usr/src/app/upload';
    logger.log(`Converting database file paths from relative to absolute (source=${source}/*, target=${target}/*)`);
    const sourceRegex = '^' + source.replaceAll(/[-[\]{}()*+?.,\\^$|#\s]/g, String.raw `\$&`);
    const items = [
        { table: 'asset', column: 'originalPath' },
        { table: 'asset', column: 'encodedVideoPath' },
        { table: 'asset', column: 'sidecarPath' },
        { table: 'asset_file', column: 'path' },
        { table: 'person', column: 'thumbnailPath' },
        { table: 'user', column: 'profileImagePath' },
    ];
    for (const { table, column } of items) {
        const query = `UPDATE "${table}" SET "${column}" = REGEXP_REPLACE("${column}", '${sourceRegex}', '${target}') WHERE "${column}" IS NOT NULL`;
        await kysely_1.sql.raw(query).execute(db);
    }
}
async function down() {
}
//# sourceMappingURL=1752759108283-ConvertToAbsolutePaths.js.map