"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemoryTable = void 0;
const decorators_1 = require("../../decorators");
const enum_1 = require("../../enum");
const functions_1 = require("../functions");
const user_table_1 = require("./user.table");
const sql_tools_1 = require("../../sql-tools");
let MemoryTable = class MemoryTable {
    id;
    createdAt;
    updatedAt;
    deletedAt;
    ownerId;
    type;
    data;
    isSaved;
    memoryAt;
    seenAt;
    showAt;
    hideAt;
    updateId;
};
exports.MemoryTable = MemoryTable;
__decorate([
    (0, sql_tools_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Object)
], MemoryTable.prototype, "id", void 0);
__decorate([
    (0, sql_tools_1.CreateDateColumn)(),
    __metadata("design:type", Object)
], MemoryTable.prototype, "createdAt", void 0);
__decorate([
    (0, sql_tools_1.UpdateDateColumn)(),
    __metadata("design:type", Object)
], MemoryTable.prototype, "updatedAt", void 0);
__decorate([
    (0, sql_tools_1.DeleteDateColumn)(),
    __metadata("design:type", Object)
], MemoryTable.prototype, "deletedAt", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => user_table_1.UserTable, { onDelete: 'CASCADE', onUpdate: 'CASCADE', nullable: false }),
    __metadata("design:type", String)
], MemoryTable.prototype, "ownerId", void 0);
__decorate([
    (0, sql_tools_1.Column)(),
    __metadata("design:type", String)
], MemoryTable.prototype, "type", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'jsonb' }),
    __metadata("design:type", Object)
], MemoryTable.prototype, "data", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'boolean', default: false }),
    __metadata("design:type", Object)
], MemoryTable.prototype, "isSaved", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'timestamp with time zone' }),
    __metadata("design:type", Object)
], MemoryTable.prototype, "memoryAt", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'timestamp with time zone', nullable: true }),
    __metadata("design:type", Object)
], MemoryTable.prototype, "seenAt", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'timestamp with time zone', nullable: true }),
    __metadata("design:type", Object)
], MemoryTable.prototype, "showAt", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'timestamp with time zone', nullable: true }),
    __metadata("design:type", Object)
], MemoryTable.prototype, "hideAt", void 0);
__decorate([
    (0, decorators_1.UpdateIdColumn)({ index: true }),
    __metadata("design:type", Object)
], MemoryTable.prototype, "updateId", void 0);
exports.MemoryTable = MemoryTable = __decorate([
    (0, sql_tools_1.Table)('memory'),
    (0, decorators_1.UpdatedAtTrigger)('memory_updatedAt'),
    (0, sql_tools_1.AfterDeleteTrigger)({
        scope: 'statement',
        function: functions_1.memory_delete_audit,
        referencingOldTableAs: 'old',
        when: 'pg_trigger_depth() = 0',
    })
], MemoryTable);
//# sourceMappingURL=memory.table.js.map