"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PersonTable = void 0;
const decorators_1 = require("../../decorators");
const functions_1 = require("../functions");
const asset_face_table_1 = require("./asset-face.table");
const user_table_1 = require("./user.table");
const sql_tools_1 = require("../../sql-tools");
let PersonTable = class PersonTable {
    id;
    createdAt;
    updatedAt;
    ownerId;
    name;
    thumbnailPath;
    isHidden;
    birthDate;
    faceAssetId;
    isFavorite;
    color;
    updateId;
};
exports.PersonTable = PersonTable;
__decorate([
    (0, sql_tools_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", Object)
], PersonTable.prototype, "id", void 0);
__decorate([
    (0, sql_tools_1.CreateDateColumn)(),
    __metadata("design:type", Object)
], PersonTable.prototype, "createdAt", void 0);
__decorate([
    (0, sql_tools_1.UpdateDateColumn)(),
    __metadata("design:type", Object)
], PersonTable.prototype, "updatedAt", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => user_table_1.UserTable, { onDelete: 'CASCADE', onUpdate: 'CASCADE', nullable: false }),
    __metadata("design:type", String)
], PersonTable.prototype, "ownerId", void 0);
__decorate([
    (0, sql_tools_1.Column)({ default: '' }),
    __metadata("design:type", Object)
], PersonTable.prototype, "name", void 0);
__decorate([
    (0, sql_tools_1.Column)({ default: '' }),
    __metadata("design:type", Object)
], PersonTable.prototype, "thumbnailPath", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'boolean', default: false }),
    __metadata("design:type", Object)
], PersonTable.prototype, "isHidden", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'date', nullable: true }),
    __metadata("design:type", Object)
], PersonTable.prototype, "birthDate", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => asset_face_table_1.AssetFaceTable, { onDelete: 'SET NULL', nullable: true }),
    __metadata("design:type", Object)
], PersonTable.prototype, "faceAssetId", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'boolean', default: false }),
    __metadata("design:type", Object)
], PersonTable.prototype, "isFavorite", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'character varying', nullable: true, default: null }),
    __metadata("design:type", Object)
], PersonTable.prototype, "color", void 0);
__decorate([
    (0, decorators_1.UpdateIdColumn)({ index: true }),
    __metadata("design:type", Object)
], PersonTable.prototype, "updateId", void 0);
exports.PersonTable = PersonTable = __decorate([
    (0, sql_tools_1.Table)('person'),
    (0, decorators_1.UpdatedAtTrigger)('person_updatedAt'),
    (0, sql_tools_1.AfterDeleteTrigger)({
        scope: 'statement',
        function: functions_1.person_delete_audit,
        referencingOldTableAs: 'old',
        when: 'pg_trigger_depth() = 0',
    }),
    (0, sql_tools_1.Check)({ name: 'person_birthDate_chk', expression: `"birthDate" <= CURRENT_DATE` })
], PersonTable);
//# sourceMappingURL=person.table.js.map