"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DuplicateService = void 0;
const common_1 = require("@nestjs/common");
const constants_1 = require("../constants");
const decorators_1 = require("../decorators");
const asset_response_dto_1 = require("../dtos/asset-response.dto");
const enum_1 = require("../enum");
const base_service_1 = require("./base.service");
const misc_1 = require("../utils/misc");
let DuplicateService = class DuplicateService extends base_service_1.BaseService {
    async getDuplicates(auth) {
        const duplicates = await this.duplicateRepository.getAll(auth.user.id);
        return duplicates.map(({ duplicateId, assets }) => ({
            duplicateId,
            assets: assets.map((asset) => (0, asset_response_dto_1.mapAsset)(asset, { auth })),
        }));
    }
    async delete(auth, id) {
        await this.duplicateRepository.delete(auth.user.id, id);
    }
    async deleteAll(auth, dto) {
        await this.duplicateRepository.deleteAll(auth.user.id, dto.ids);
    }
    async handleQueueSearchDuplicates({ force }) {
        const { machineLearning } = await this.getConfig({ withCache: false });
        if (!(0, misc_1.isDuplicateDetectionEnabled)(machineLearning)) {
            return enum_1.JobStatus.Skipped;
        }
        let jobs = [];
        const queueAll = async () => {
            await this.jobRepository.queueAll(jobs);
            jobs = [];
        };
        const assets = this.assetJobRepository.streamForSearchDuplicates(force);
        for await (const asset of assets) {
            jobs.push({ name: enum_1.JobName.AssetDetectDuplicates, data: { id: asset.id } });
            if (jobs.length >= constants_1.JOBS_ASSET_PAGINATION_SIZE) {
                await queueAll();
            }
        }
        await queueAll();
        return enum_1.JobStatus.Success;
    }
    async handleSearchDuplicates({ id }) {
        const { machineLearning } = await this.getConfig({ withCache: true });
        if (!(0, misc_1.isDuplicateDetectionEnabled)(machineLearning)) {
            return enum_1.JobStatus.Skipped;
        }
        const asset = await this.assetJobRepository.getForSearchDuplicatesJob(id);
        if (!asset) {
            this.logger.error(`Asset ${id} not found`);
            return enum_1.JobStatus.Failed;
        }
        if (asset.stackId) {
            this.logger.debug(`Asset ${id} is part of a stack, skipping`);
            return enum_1.JobStatus.Skipped;
        }
        if (asset.visibility === enum_1.AssetVisibility.Hidden) {
            this.logger.debug(`Asset ${id} is not visible, skipping`);
            return enum_1.JobStatus.Skipped;
        }
        if (asset.visibility === enum_1.AssetVisibility.Locked) {
            this.logger.debug(`Asset ${id} is locked, skipping`);
            return enum_1.JobStatus.Skipped;
        }
        if (!asset.embedding) {
            this.logger.debug(`Asset ${id} is missing embedding`);
            return enum_1.JobStatus.Failed;
        }
        const duplicateAssets = await this.duplicateRepository.search({
            assetId: asset.id,
            embedding: asset.embedding,
            maxDistance: machineLearning.duplicateDetection.maxDistance,
            type: asset.type,
            userIds: [asset.ownerId],
        });
        let assetIds = [asset.id];
        if (duplicateAssets.length > 0) {
            this.logger.debug(`Found ${duplicateAssets.length} duplicate${duplicateAssets.length === 1 ? '' : 's'} for asset ${asset.id}`);
            assetIds = await this.updateDuplicates(asset, duplicateAssets);
        }
        else if (asset.duplicateId) {
            this.logger.debug(`No duplicates found for asset ${asset.id}, removing duplicateId`);
            await this.assetRepository.update({ id: asset.id, duplicateId: null });
        }
        const duplicatesDetectedAt = new Date();
        await this.assetRepository.upsertJobStatus(...assetIds.map((assetId) => ({ assetId, duplicatesDetectedAt })));
        return enum_1.JobStatus.Success;
    }
    async updateDuplicates(asset, duplicateAssets) {
        const duplicateIds = [
            ...new Set(duplicateAssets
                .filter((asset) => !!asset.duplicateId)
                .map((duplicate) => duplicate.duplicateId)),
        ];
        const targetDuplicateId = asset.duplicateId ?? duplicateIds.shift() ?? this.cryptoRepository.randomUUID();
        const assetIdsToUpdate = duplicateAssets
            .filter((asset) => asset.duplicateId !== targetDuplicateId)
            .map((duplicate) => duplicate.assetId);
        assetIdsToUpdate.push(asset.id);
        await this.duplicateRepository.merge({
            targetId: targetDuplicateId,
            assetIds: assetIdsToUpdate,
            sourceIds: duplicateIds,
        });
        return assetIdsToUpdate;
    }
};
exports.DuplicateService = DuplicateService;
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.AssetDetectDuplicatesQueueAll, queue: enum_1.QueueName.DuplicateDetection }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], DuplicateService.prototype, "handleQueueSearchDuplicates", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.AssetDetectDuplicates, queue: enum_1.QueueName.DuplicateDetection }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], DuplicateService.prototype, "handleSearchDuplicates", null);
exports.DuplicateService = DuplicateService = __decorate([
    (0, common_1.Injectable)()
], DuplicateService);
//# sourceMappingURL=duplicate.service.js.map