"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LibraryService = void 0;
const common_1 = require("@nestjs/common");
const node_constants_1 = require("node:constants");
const node_path_1 = __importStar(require("node:path"));
const picomatch_1 = __importDefault(require("picomatch"));
const constants_1 = require("../constants");
const storage_core_1 = require("../cores/storage.core");
const decorators_1 = require("../decorators");
const library_dto_1 = require("../dtos/library.dto");
const enum_1 = require("../enum");
const library_repository_1 = require("../repositories/library.repository");
const base_service_1 = require("./base.service");
const mime_types_1 = require("../utils/mime-types");
const misc_1 = require("../utils/misc");
let LibraryService = class LibraryService extends base_service_1.BaseService {
    watchLibraries = false;
    lock = false;
    watchers = {};
    async onConfigInit({ newConfig: { library: { watch, scan }, }, }) {
        this.lock = await this.databaseRepository.tryLock(enum_1.DatabaseLock.Library);
        this.watchLibraries = this.lock && watch.enabled;
        if (this.lock) {
            this.cronRepository.create({
                name: enum_1.CronJob.LibraryScan,
                expression: scan.cronExpression,
                onTick: () => (0, misc_1.handlePromiseError)(this.jobRepository.queue({ name: enum_1.JobName.LibraryScanQueueAll }), this.logger),
                start: scan.enabled,
            });
        }
        if (this.watchLibraries) {
            await this.watchAll();
        }
    }
    async onConfigUpdate({ newConfig: { library } }) {
        if (!this.lock) {
            return;
        }
        this.cronRepository.update({
            name: enum_1.CronJob.LibraryScan,
            expression: library.scan.cronExpression,
            start: library.scan.enabled,
        });
        if (library.watch.enabled !== this.watchLibraries) {
            this.watchLibraries = library.watch.enabled;
            await (this.watchLibraries ? this.watchAll() : this.unwatchAll());
        }
    }
    async watch(id) {
        if (!this.watchLibraries) {
            return false;
        }
        const library = await this.findOrFail(id);
        if (library.importPaths.length === 0) {
            return false;
        }
        await this.unwatch(id);
        this.logger.log(`Starting to watch library ${library.id} with import path(s) ${library.importPaths}`);
        const matcher = (0, picomatch_1.default)(`**/*{${mime_types_1.mimeTypes.getSupportedFileExtensions().join(',')}}`, {
            nocase: true,
            ignore: library.exclusionPatterns,
        });
        let _resolve;
        const ready$ = new Promise((resolve) => (_resolve = resolve));
        const handler = async (event, path) => {
            if (matcher(path)) {
                this.logger.debug(`File ${event} event received for ${path} in library ${library.id}}`);
                await this.jobRepository.queue({
                    name: enum_1.JobName.LibrarySyncFiles,
                    data: { libraryId: library.id, paths: [path] },
                });
            }
            else {
                this.logger.verbose(`Ignoring file ${event} event for ${path} in library ${library.id}`);
            }
        };
        const deletionHandler = async (path) => {
            this.logger.debug(`File unlink event received for ${path} in library ${library.id}}`);
            await this.jobRepository.queue({
                name: enum_1.JobName.LibraryRemoveAsset,
                data: { libraryId: library.id, paths: [path] },
            });
        };
        this.watchers[id] = this.storageRepository.watch(library.importPaths, {
            usePolling: false,
            ignoreInitial: true,
            awaitWriteFinish: {
                stabilityThreshold: 5000,
                pollInterval: 1000,
            },
        }, {
            onReady: () => _resolve(),
            onAdd: (path) => {
                return (0, misc_1.handlePromiseError)(handler('add', path), this.logger);
            },
            onChange: (path) => {
                return (0, misc_1.handlePromiseError)(handler('change', path), this.logger);
            },
            onUnlink: (path) => {
                return (0, misc_1.handlePromiseError)(deletionHandler(path), this.logger);
            },
            onError: (error) => {
                this.logger.error(`Library watcher for library ${library.id} encountered error: ${error}`);
            },
        });
        await ready$;
        return true;
    }
    async unwatch(id) {
        if (this.watchers[id]) {
            await this.watchers[id]();
            delete this.watchers[id];
        }
    }
    async onShutdown() {
        await this.unwatchAll();
    }
    async unwatchAll() {
        if (!this.lock) {
            return false;
        }
        for (const id in this.watchers) {
            await this.unwatch(id);
        }
    }
    async watchAll() {
        if (!this.lock) {
            return false;
        }
        const libraries = await this.libraryRepository.getAll(false);
        for (const library of libraries) {
            await this.watch(library.id);
        }
    }
    async getStatistics(id) {
        const statistics = await this.libraryRepository.getStatistics(id);
        if (!statistics) {
            throw new common_1.BadRequestException(`Library ${id} not found`);
        }
        return statistics;
    }
    async get(id) {
        const library = await this.findOrFail(id);
        return (0, library_dto_1.mapLibrary)(library);
    }
    async getAll() {
        const libraries = await this.libraryRepository.getAll(false);
        return libraries.map((library) => (0, library_dto_1.mapLibrary)(library));
    }
    async handleQueueCleanup() {
        this.logger.log('Checking for any libraries pending deletion...');
        const pendingDeletions = await this.libraryRepository.getAllDeleted();
        if (pendingDeletions.length > 0) {
            const libraryString = pendingDeletions.length === 1 ? 'library' : 'libraries';
            this.logger.log(`Found ${pendingDeletions.length} ${libraryString} pending deletion, cleaning up...`);
            await this.jobRepository.queueAll(pendingDeletions.map((libraryToDelete) => ({ name: enum_1.JobName.LibraryDelete, data: { id: libraryToDelete.id } })));
        }
        return enum_1.JobStatus.Success;
    }
    async create(dto) {
        const library = await this.libraryRepository.create({
            ownerId: dto.ownerId,
            name: dto.name ?? 'New External Library',
            importPaths: dto.importPaths ?? [],
            exclusionPatterns: dto.exclusionPatterns ?? ['**/@eaDir/**', '**/._*', '**/#recycle/**', '**/#snapshot/**'],
        });
        return (0, library_dto_1.mapLibrary)(library);
    }
    async handleSyncFiles(job) {
        const library = await this.libraryRepository.get(job.libraryId);
        if (!library) {
            this.logger.debug(`Library ${job.libraryId} not found, skipping file import`);
            return enum_1.JobStatus.Failed;
        }
        else if (library.deletedAt) {
            this.logger.debug(`Library ${job.libraryId} is deleted, won't import assets into it`);
            return enum_1.JobStatus.Failed;
        }
        const assetImports = [];
        await Promise.all(job.paths.map((path) => this.processEntity(path, library.ownerId, job.libraryId)
            .then((asset) => assetImports.push(asset))
            .catch((error) => this.logger.error(`Error processing ${path} for library ${job.libraryId}: ${error}`))));
        const assetIds = [];
        for (let i = 0; i < assetImports.length; i += 5000) {
            const chunk = assetImports.slice(i, i + 5000);
            await this.assetRepository.createAll(chunk).then((assets) => assetIds.push(...assets.map((asset) => asset.id)));
        }
        const progressMessage = job.progressCounter && job.totalAssets
            ? `(${job.progressCounter} of ${job.totalAssets})`
            : `(${job.progressCounter} done so far)`;
        this.logger.log(`Imported ${assetIds.length} ${progressMessage} file(s) into library ${job.libraryId}`);
        await this.queuePostSyncJobs(assetIds);
        return enum_1.JobStatus.Success;
    }
    async validateImportPath(importPath) {
        const validation = new library_dto_1.ValidateLibraryImportPathResponseDto();
        validation.importPath = importPath;
        if (storage_core_1.StorageCore.isImmichPath(importPath)) {
            validation.message = 'Cannot use media upload folder for external libraries';
            return validation;
        }
        if (!(0, node_path_1.isAbsolute)(importPath)) {
            validation.message = `Import path must be absolute, try ${node_path_1.default.resolve(importPath)}`;
            return validation;
        }
        try {
            const stat = await this.storageRepository.stat(importPath);
            if (!stat.isDirectory()) {
                validation.message = 'Not a directory';
                return validation;
            }
        }
        catch (error) {
            if (error.code === 'ENOENT') {
                validation.message = 'Path does not exist (ENOENT)';
                return validation;
            }
            validation.message = String(error);
            return validation;
        }
        const access = await this.storageRepository.checkFileExists(importPath, node_constants_1.R_OK);
        if (!access) {
            validation.message = 'Lacking read permission for folder';
            return validation;
        }
        validation.isValid = true;
        return validation;
    }
    async validate(id, dto) {
        const importPaths = await Promise.all((dto.importPaths || []).map((importPath) => this.validateImportPath(importPath)));
        return { importPaths };
    }
    async update(id, dto) {
        await this.findOrFail(id);
        if (dto.importPaths) {
            const validation = await this.validate(id, { importPaths: dto.importPaths });
            if (validation.importPaths) {
                for (const path of validation.importPaths) {
                    if (!path.isValid) {
                        throw new common_1.BadRequestException(`Invalid import path: ${path.message}`);
                    }
                }
            }
        }
        const library = await this.libraryRepository.update(id, dto);
        return (0, library_dto_1.mapLibrary)(library);
    }
    async delete(id) {
        await this.findOrFail(id);
        if (this.watchLibraries) {
            await this.unwatch(id);
        }
        await this.libraryRepository.softDelete(id);
        await this.jobRepository.queue({ name: enum_1.JobName.LibraryDelete, data: { id } });
    }
    async handleDeleteLibrary(job) {
        const libraryId = job.id;
        await this.assetRepository.updateByLibraryId(libraryId, { deletedAt: new Date() });
        let assetsFound = false;
        let chunk = [];
        const queueChunk = async () => {
            if (chunk.length > 0) {
                assetsFound = true;
                this.logger.debug(`Queueing deletion of ${chunk.length} asset(s) in library ${libraryId}`);
                await this.jobRepository.queueAll(chunk.map((id) => ({ name: enum_1.JobName.AssetDelete, data: { id, deleteOnDisk: false } })));
                chunk = [];
            }
        };
        this.logger.debug(`Will delete all assets in library ${libraryId}`);
        const assets = this.libraryRepository.streamAssetIds(libraryId);
        for await (const asset of assets) {
            chunk.push(asset.id);
            if (chunk.length >= constants_1.JOBS_LIBRARY_PAGINATION_SIZE) {
                await queueChunk();
            }
        }
        await queueChunk();
        if (!assetsFound) {
            this.logger.log(`Deleting library ${libraryId}`);
            await this.libraryRepository.delete(libraryId);
        }
        return enum_1.JobStatus.Success;
    }
    async processEntity(filePath, ownerId, libraryId) {
        const assetPath = node_path_1.default.normalize(filePath);
        const stat = await this.storageRepository.stat(assetPath);
        return {
            ownerId,
            libraryId,
            checksum: this.cryptoRepository.hashSha1(`path:${assetPath}`),
            originalPath: assetPath,
            fileCreatedAt: stat.mtime,
            fileModifiedAt: stat.mtime,
            localDateTime: stat.mtime,
            deviceAssetId: `${(0, node_path_1.basename)(assetPath)}`.replaceAll(/\s+/g, ''),
            deviceId: 'Library Import',
            type: mime_types_1.mimeTypes.isVideo(assetPath) ? enum_1.AssetType.Video : enum_1.AssetType.Image,
            originalFileName: (0, node_path_1.parse)(assetPath).base,
            isExternal: true,
            livePhotoVideoId: null,
        };
    }
    async queuePostSyncJobs(assetIds) {
        this.logger.debug(`Queuing sidecar discovery for ${assetIds.length} asset(s)`);
        await this.jobRepository.queueAll(assetIds.map((assetId) => ({
            name: enum_1.JobName.SidecarCheck,
            data: { id: assetId, source: 'upload' },
        })));
    }
    async queueScan(id) {
        await this.findOrFail(id);
        this.logger.log(`Starting to scan library ${id}`);
        await this.jobRepository.queue({
            name: enum_1.JobName.LibrarySyncFilesQueueAll,
            data: {
                id,
            },
        });
        await this.jobRepository.queue({ name: enum_1.JobName.LibrarySyncAssetsQueueAll, data: { id } });
    }
    async queueScanAll() {
        await this.jobRepository.queue({ name: enum_1.JobName.LibraryScanQueueAll, data: {} });
    }
    async handleQueueScanAll() {
        this.logger.log(`Initiating scan of all external libraries...`);
        await this.jobRepository.queue({ name: enum_1.JobName.LibraryDeleteCheck, data: {} });
        const libraries = await this.libraryRepository.getAll(true);
        await this.jobRepository.queueAll(libraries.map((library) => ({
            name: enum_1.JobName.LibrarySyncFilesQueueAll,
            data: {
                id: library.id,
            },
        })));
        await this.jobRepository.queueAll(libraries.map((library) => ({
            name: enum_1.JobName.LibrarySyncAssetsQueueAll,
            data: {
                id: library.id,
            },
        })));
        return enum_1.JobStatus.Success;
    }
    async handleSyncAssets(job) {
        const assets = await this.assetJobRepository.getForSyncAssets(job.assetIds);
        const assetIdsToOffline = [];
        const trashedAssetIdsToOffline = [];
        const assetIdsToOnline = [];
        const trashedAssetIdsToOnline = [];
        const assetIdsToUpdate = [];
        this.logger.debug(`Checking batch of ${assets.length} existing asset(s) in library ${job.libraryId}`);
        const stats = await Promise.all(assets.map((asset) => this.storageRepository.stat(asset.originalPath).catch(() => null)));
        for (let i = 0; i < assets.length; i++) {
            const asset = assets[i];
            const stat = stats[i];
            const action = this.checkExistingAsset(asset, stat);
            switch (action) {
                case library_repository_1.AssetSyncResult.OFFLINE: {
                    if (asset.status === enum_1.AssetStatus.Trashed) {
                        trashedAssetIdsToOffline.push(asset.id);
                    }
                    else {
                        assetIdsToOffline.push(asset.id);
                    }
                    break;
                }
                case library_repository_1.AssetSyncResult.UPDATE: {
                    assetIdsToUpdate.push(asset.id);
                    break;
                }
                case library_repository_1.AssetSyncResult.CHECK_OFFLINE: {
                    const isInImportPath = job.importPaths.find((path) => asset.originalPath.startsWith(path));
                    if (!isInImportPath) {
                        this.logger.verbose(`Offline asset ${asset.originalPath} is still not in any import path, keeping offline in library ${job.libraryId}`);
                        break;
                    }
                    const isExcluded = job.exclusionPatterns.some((pattern) => picomatch_1.default.isMatch(asset.originalPath, pattern));
                    if (!isExcluded) {
                        this.logger.debug(`Offline asset ${asset.originalPath} is now online in library ${job.libraryId}`);
                        if (asset.status === enum_1.AssetStatus.Trashed) {
                            trashedAssetIdsToOnline.push(asset.id);
                        }
                        else {
                            assetIdsToOnline.push(asset.id);
                        }
                        break;
                    }
                    this.logger.verbose(`Offline asset ${asset.originalPath} is in an import path but still covered by exclusion pattern, keeping offline in library ${job.libraryId}`);
                    break;
                }
            }
        }
        const promises = [];
        if (assetIdsToOffline.length > 0) {
            promises.push(this.assetRepository.updateAll(assetIdsToOffline, { isOffline: true, deletedAt: new Date() }));
        }
        if (trashedAssetIdsToOffline.length > 0) {
            promises.push(this.assetRepository.updateAll(trashedAssetIdsToOffline, { isOffline: true }));
        }
        if (assetIdsToOnline.length > 0) {
            promises.push(this.assetRepository.updateAll(assetIdsToOnline, { isOffline: false, deletedAt: null }));
        }
        if (trashedAssetIdsToOnline.length > 0) {
            promises.push(this.assetRepository.updateAll(trashedAssetIdsToOnline, { isOffline: false }));
        }
        if (assetIdsToUpdate.length > 0) {
            promises.push(this.queuePostSyncJobs(assetIdsToUpdate));
        }
        await Promise.all(promises);
        const remainingCount = assets.length - assetIdsToOffline.length - assetIdsToUpdate.length - assetIdsToOnline.length;
        const cumulativePercentage = ((100 * job.progressCounter) / job.totalAssets).toFixed(1);
        this.logger.log(`Checked existing asset(s): ${assetIdsToOffline.length + trashedAssetIdsToOffline.length} offlined, ${assetIdsToOnline.length + trashedAssetIdsToOnline.length} onlined, ${assetIdsToUpdate.length} updated, ${remainingCount} unchanged of current batch of ${assets.length} (Total progress: ${job.progressCounter} of ${job.totalAssets}, ${cumulativePercentage} %) in library ${job.libraryId}.`);
        return enum_1.JobStatus.Success;
    }
    checkExistingAsset(asset, stat) {
        if (!stat) {
            if (asset.isOffline) {
                this.logger.verbose(`Asset ${asset.originalPath} is still not accessible, keeping offline in library ${asset.libraryId}`);
                return library_repository_1.AssetSyncResult.DO_NOTHING;
            }
            this.logger.debug(`Asset ${asset.originalPath} is no longer on disk or is inaccessible because of permissions, marking offline in library ${asset.libraryId}`);
            return library_repository_1.AssetSyncResult.OFFLINE;
        }
        if (asset.isOffline && asset.status !== enum_1.AssetStatus.Deleted) {
            return library_repository_1.AssetSyncResult.CHECK_OFFLINE;
        }
        if (stat.mtime.valueOf() !== asset.fileModifiedAt.valueOf()) {
            this.logger.verbose(`Asset ${asset.originalPath} needs metadata extraction in library ${asset.libraryId}`);
            return library_repository_1.AssetSyncResult.UPDATE;
        }
        return library_repository_1.AssetSyncResult.DO_NOTHING;
    }
    async handleQueueSyncFiles(job) {
        const library = await this.libraryRepository.get(job.id);
        if (!library) {
            this.logger.debug(`Library ${job.id} not found, skipping refresh`);
            return enum_1.JobStatus.Skipped;
        }
        this.logger.debug(`Validating import paths for library ${library.id}...`);
        const validImportPaths = [];
        for (const importPath of library.importPaths) {
            const validation = await this.validateImportPath(importPath);
            if (validation.isValid) {
                validImportPaths.push(node_path_1.default.normalize(importPath));
            }
            else {
                this.logger.warn(`Skipping invalid import path: ${importPath}. Reason: ${validation.message}`);
            }
        }
        if (validImportPaths.length === 0) {
            this.logger.warn(`No valid import paths found for library ${library.id}`);
            return enum_1.JobStatus.Skipped;
        }
        const pathsOnDisk = this.storageRepository.walk({
            pathsToCrawl: validImportPaths,
            includeHidden: false,
            exclusionPatterns: library.exclusionPatterns,
            take: constants_1.JOBS_LIBRARY_PAGINATION_SIZE,
        });
        let importCount = 0;
        let crawlCount = 0;
        this.logger.log(`Starting disk crawl of ${validImportPaths.length} import path(s) for library ${library.id}...`);
        for await (const pathBatch of pathsOnDisk) {
            crawlCount += pathBatch.length;
            const paths = await this.assetRepository.filterNewExternalAssetPaths(library.id, pathBatch);
            if (paths.length > 0) {
                importCount += paths.length;
                await this.jobRepository.queue({
                    name: enum_1.JobName.LibrarySyncFiles,
                    data: {
                        libraryId: library.id,
                        paths,
                        progressCounter: crawlCount,
                    },
                });
            }
            this.logger.log(`Crawled ${crawlCount} file(s) so far: ${paths.length} of current batch of ${pathBatch.length} will be imported to library ${library.id}...`);
        }
        this.logger.log(`Finished disk crawl, ${crawlCount} file(s) found on disk and queued ${importCount} file(s) for import into ${library.id}`);
        await this.libraryRepository.update(job.id, { refreshedAt: new Date() });
        return enum_1.JobStatus.Success;
    }
    async handleAssetRemoval(job) {
        this.logger.verbose(`Deleting asset(s) ${job.paths} from library ${job.libraryId}`);
        for (const assetPath of job.paths) {
            const asset = await this.assetRepository.getByLibraryIdAndOriginalPath(job.libraryId, assetPath);
            if (asset) {
                await this.assetRepository.remove(asset);
            }
        }
        return enum_1.JobStatus.Success;
    }
    async handleQueueSyncAssets(job) {
        const library = await this.libraryRepository.get(job.id);
        if (!library) {
            return enum_1.JobStatus.Skipped;
        }
        const assetCount = await this.assetRepository.getLibraryAssetCount(job.id);
        if (!assetCount) {
            this.logger.log(`Library ${library.id} is empty, no need to check assets`);
            return enum_1.JobStatus.Success;
        }
        this.logger.log(`Checking ${assetCount} asset(s) against import paths and exclusion patterns in library ${library.id}...`);
        const offlineResult = await this.assetRepository.detectOfflineExternalAssets(library.id, library.importPaths, library.exclusionPatterns);
        const affectedAssetCount = Number(offlineResult.numUpdatedRows);
        this.logger.log(`${affectedAssetCount} asset(s) out of ${assetCount} were offlined due to import paths and/or exclusion pattern(s) in library ${library.id}`);
        if (affectedAssetCount === assetCount) {
            return enum_1.JobStatus.Success;
        }
        let chunk = [];
        let count = 0;
        const queueChunk = async () => {
            if (chunk.length > 0) {
                count += chunk.length;
                await this.jobRepository.queue({
                    name: enum_1.JobName.LibrarySyncAssets,
                    data: {
                        libraryId: library.id,
                        importPaths: library.importPaths,
                        exclusionPatterns: library.exclusionPatterns,
                        assetIds: chunk.map((id) => id),
                        progressCounter: count,
                        totalAssets: assetCount,
                    },
                });
                chunk = [];
                const completePercentage = ((100 * count) / assetCount).toFixed(1);
                this.logger.log(`Queued check of ${count} of ${assetCount} (${completePercentage} %) existing asset(s) so far in library ${library.id}`);
            }
        };
        this.logger.log(`Scanning library ${library.id} for assets missing from disk...`);
        const existingAssets = this.libraryRepository.streamAssetIds(library.id);
        for await (const asset of existingAssets) {
            chunk.push(asset.id);
            if (chunk.length === constants_1.JOBS_LIBRARY_PAGINATION_SIZE) {
                await queueChunk();
            }
        }
        await queueChunk();
        this.logger.log(`Finished queuing ${count} asset check(s) for library ${library.id}`);
        return enum_1.JobStatus.Success;
    }
    async findOrFail(id) {
        const library = await this.libraryRepository.get(id);
        if (!library) {
            throw new common_1.BadRequestException('Library not found');
        }
        return library;
    }
};
exports.LibraryService = LibraryService;
__decorate([
    (0, decorators_1.OnEvent)({ name: 'ConfigInit', workers: [enum_1.ImmichWorker.Microservices] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], LibraryService.prototype, "onConfigInit", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'ConfigUpdate', server: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], LibraryService.prototype, "onConfigUpdate", null);
__decorate([
    (0, decorators_1.OnEvent)({ name: 'AppShutdown' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], LibraryService.prototype, "onShutdown", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.LibraryDeleteCheck, queue: enum_1.QueueName.Library }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], LibraryService.prototype, "handleQueueCleanup", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.LibrarySyncFiles, queue: enum_1.QueueName.Library }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], LibraryService.prototype, "handleSyncFiles", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.LibraryDelete, queue: enum_1.QueueName.Library }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], LibraryService.prototype, "handleDeleteLibrary", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.LibraryScanQueueAll, queue: enum_1.QueueName.Library }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], LibraryService.prototype, "handleQueueScanAll", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.LibrarySyncAssets, queue: enum_1.QueueName.Library }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], LibraryService.prototype, "handleSyncAssets", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.LibrarySyncFilesQueueAll, queue: enum_1.QueueName.Library }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], LibraryService.prototype, "handleQueueSyncFiles", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.LibraryRemoveAsset, queue: enum_1.QueueName.Library }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], LibraryService.prototype, "handleAssetRemoval", null);
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.LibrarySyncAssetsQueueAll, queue: enum_1.QueueName.Library }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], LibraryService.prototype, "handleQueueSyncAssets", null);
exports.LibraryService = LibraryService = __decorate([
    (0, common_1.Injectable)()
], LibraryService);
//# sourceMappingURL=library.service.js.map