import { PluginResponseDto } from 'src/dtos/plugin.dto';
import { JobName, JobStatus } from 'src/enum';
import { ArgOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
import { JobOf } from 'src/types';
export declare class PluginService extends BaseService {
    private pluginJwtSecret;
    private loadedPlugins;
    private hostFunctions;
    onBootstrap(): Promise<void>;
    getAll(): Promise<PluginResponseDto[]>;
    get(id: string): Promise<PluginResponseDto>;
    loadPluginsFromManifests(): Promise<void>;
    private loadExternalPlugins;
    private loadPluginToDatabase;
    private readAndValidateManifest;
    private loadPlugins;
    handleAssetCreate({ asset }: ArgOf<'AssetCreate'>): Promise<void>;
    private handleTrigger;
    handleWorkflowRun({ id: workflowId, type, event }: JobOf<JobName.WorkflowRun>): Promise<JobStatus>;
    private executeFilters;
    private executeActions;
}
