"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SystemMetadataService = void 0;
const common_1 = require("@nestjs/common");
const enum_1 = require("../enum");
const base_service_1 = require("./base.service");
let SystemMetadataService = class SystemMetadataService extends base_service_1.BaseService {
    async getAdminOnboarding() {
        const value = await this.systemMetadataRepository.get(enum_1.SystemMetadataKey.AdminOnboarding);
        return { isOnboarded: false, ...value };
    }
    async updateAdminOnboarding(dto) {
        await this.systemMetadataRepository.set(enum_1.SystemMetadataKey.AdminOnboarding, {
            isOnboarded: dto.isOnboarded,
        });
    }
    async getReverseGeocodingState() {
        const value = await this.systemMetadataRepository.get(enum_1.SystemMetadataKey.ReverseGeocodingState);
        return { lastUpdate: null, lastImportFileName: null, ...value };
    }
    async getVersionCheckState() {
        const value = await this.systemMetadataRepository.get(enum_1.SystemMetadataKey.VersionCheckState);
        return { checkedAt: null, releaseVersion: null, ...value };
    }
};
exports.SystemMetadataService = SystemMetadataService;
exports.SystemMetadataService = SystemMetadataService = __decorate([
    (0, common_1.Injectable)()
], SystemMetadataService);
//# sourceMappingURL=system-metadata.service.js.map