"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processOverrides = void 0;
const function_transformer_1 = require("../transformers/function.transformer");
const index_transformer_1 = require("../transformers/index.transformer");
const trigger_transformer_1 = require("../transformers/trigger.transformer");
const processOverrides = (ctx) => {
    if (ctx.options.overrides === false) {
        return;
    }
    for (const func of ctx.functions) {
        if (!func.synchronize) {
            continue;
        }
        ctx.overrides.push({
            name: `function_${func.name}`,
            value: { type: 'function', name: func.name, sql: (0, function_transformer_1.asFunctionCreate)(func) },
            synchronize: true,
        });
    }
    for (const { triggers, indexes } of ctx.tables) {
        for (const trigger of triggers) {
            if (!trigger.synchronize) {
                continue;
            }
            ctx.overrides.push({
                name: `trigger_${trigger.name}`,
                value: { type: 'trigger', name: trigger.name, sql: (0, trigger_transformer_1.asTriggerCreate)(trigger) },
                synchronize: true,
            });
        }
        for (const index of indexes) {
            if (!index.synchronize) {
                continue;
            }
            if (index.expression || index.using || index.with || index.where) {
                ctx.overrides.push({
                    name: `index_${index.name}`,
                    value: { type: 'index', name: index.name, sql: (0, index_transformer_1.asIndexCreate)(index) },
                    synchronize: true,
                });
            }
        }
    }
};
exports.processOverrides = processOverrides;
//# sourceMappingURL=override.processor.js.map