import { INestApplication } from '@nestjs/common';
import { SystemConfig } from 'src/config';
import { LoggingRepository } from 'src/repositories/logging.repository';
export declare class ImmichStartupError extends Error {
}
export declare const isStartUpError: (error: unknown) => error is ImmichStartupError;
export declare const getKeyByValue: (object: Record<string, unknown>, value: unknown) => string | undefined;
export declare const getMethodNames: (instance: any) => string[];
export declare const getExternalDomain: (server: SystemConfig["server"], defaultDomain?: string) => string;
export declare const getKeysDeep: (target: unknown, path?: string[]) => string[];
export declare const unsetDeep: (object: unknown, key: string) => unknown;
export declare const isSmartSearchEnabled: (machineLearning: SystemConfig["machineLearning"]) => boolean;
export declare const isOcrEnabled: (machineLearning: SystemConfig["machineLearning"]) => boolean;
export declare const isFacialRecognitionEnabled: (machineLearning: SystemConfig["machineLearning"]) => boolean;
export declare const isDuplicateDetectionEnabled: (machineLearning: SystemConfig["machineLearning"]) => boolean;
export declare const isFaceImportEnabled: (metadata: SystemConfig["metadata"]) => boolean;
export declare const isConnectionAborted: (error: Error | any) => boolean;
export declare const handlePromiseError: <T>(promise: Promise<T>, logger: LoggingRepository) => void;
export interface OpenGraphTags {
    title: string;
    description: string;
    imageUrl?: string;
}
export declare function getCLIPModelInfo(modelName: string): {
    dimSize: number;
};
export declare const routeToErrorMessage: (methodName: string) => string;
export declare const useSwagger: (app: INestApplication, { write }: {
    write: boolean;
}) => void;
export declare const globToSqlPattern: (glob: string) => string;
export declare function clamp(value: number, min: number, max: number): number;
