"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setIsEqual = exports.setIsSuperset = exports.setDifference = exports.setUnion = void 0;
const setUnion = (...sets) => {
    const union = new Set(sets[0]);
    for (const set of sets.slice(1)) {
        for (const element of set) {
            union.add(element);
        }
    }
    return union;
};
exports.setUnion = setUnion;
const setDifference = (setA, ...sets) => {
    const difference = new Set(setA);
    for (const set of sets) {
        for (const element of set) {
            difference.delete(element);
        }
    }
    return difference;
};
exports.setDifference = setDifference;
const setIsSuperset = (set, subset) => {
    for (const element of subset) {
        if (!set.has(element)) {
            return false;
        }
    }
    return true;
};
exports.setIsSuperset = setIsSuperset;
const setIsEqual = (setA, setB) => {
    return setA.size === setB.size && (0, exports.setIsSuperset)(setA, setB);
};
exports.setIsEqual = setIsEqual;
//# sourceMappingURL=set.js.map