"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.serialize = exports.mapJsonLine = exports.toAck = exports.fromAck = void 0;
const fromAck = (ack) => {
    const [type, updateId, extraId] = ack.split('|');
    return { type: type, updateId, extraId };
};
exports.fromAck = fromAck;
const toAck = ({ type, updateId, extraId }) => [type, updateId, extraId].filter((v) => v !== undefined).join('|');
exports.toAck = toAck;
const mapJsonLine = (object) => JSON.stringify(object) + '\n';
exports.mapJsonLine = mapJsonLine;
const serialize = ({ type, data, ids, ackType, }) => (0, exports.mapJsonLine)({ type, data, ack: (0, exports.toAck)({ type: ackType ?? type, updateId: ids[0], extraId: ids[1] }) });
exports.serialize = serialize;
//# sourceMappingURL=sync.js.map