"use strict";
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MEMORY_LABELS = exports.NETWORK_LABELS = exports.CPU_LABELS = exports.ATTRIBUTE_NAMES = exports.METRIC_NAMES = void 0;
var METRIC_NAMES;
(function (METRIC_NAMES) {
    METRIC_NAMES["CPU_TIME"] = "system.cpu.time";
    METRIC_NAMES["CPU_UTILIZATION"] = "system.cpu.utilization";
    METRIC_NAMES["MEMORY_USAGE"] = "system.memory.usage";
    METRIC_NAMES["MEMORY_UTILIZATION"] = "system.memory.utilization";
    METRIC_NAMES["NETWORK_DROPPED"] = "system.network.dropped";
    METRIC_NAMES["NETWORK_ERRORS"] = "system.network.errors";
    METRIC_NAMES["NETWORK_IO"] = "system.network.io";
    METRIC_NAMES["PROCESS_CPU_TIME"] = "process.cpu.time";
    METRIC_NAMES["PROCESS_CPU_UTILIZATION"] = "process.cpu.utilization";
    METRIC_NAMES["PROCESS_MEMORY_USAGE"] = "process.memory.usage";
})(METRIC_NAMES = exports.METRIC_NAMES || (exports.METRIC_NAMES = {}));
var ATTRIBUTE_NAMES;
(function (ATTRIBUTE_NAMES) {
    ATTRIBUTE_NAMES["SYSTEM_CPU_LOGICAL_NUMBER"] = "system.cpu.logical_number";
    ATTRIBUTE_NAMES["SYSTEM_CPU_STATE"] = "system.cpu.state";
    ATTRIBUTE_NAMES["SYSTEM_MEMORY_STATE"] = "system.memory.state";
    ATTRIBUTE_NAMES["SYSTEM_DEVICE"] = "system.device";
    ATTRIBUTE_NAMES["NETWORK_IO_DIRECTION"] = "network.io.direction";
    ATTRIBUTE_NAMES["SYSTEM_NETWORK_STATE"] = "system.network.state";
    ATTRIBUTE_NAMES["PROCESS_CPU_STATE"] = "process.cpu.state";
})(ATTRIBUTE_NAMES = exports.ATTRIBUTE_NAMES || (exports.ATTRIBUTE_NAMES = {}));
var CPU_LABELS;
(function (CPU_LABELS) {
    CPU_LABELS["USER"] = "user";
    CPU_LABELS["SYSTEM"] = "system";
    CPU_LABELS["IDLE"] = "idle";
    CPU_LABELS["INTERRUPT"] = "interrupt";
    CPU_LABELS["NICE"] = "nice";
})(CPU_LABELS = exports.CPU_LABELS || (exports.CPU_LABELS = {}));
var NETWORK_LABELS;
(function (NETWORK_LABELS) {
    NETWORK_LABELS["RECEIVE"] = "receive";
    NETWORK_LABELS["TRANSMIT"] = "transmit";
})(NETWORK_LABELS = exports.NETWORK_LABELS || (exports.NETWORK_LABELS = {}));
var MEMORY_LABELS;
(function (MEMORY_LABELS) {
    MEMORY_LABELS["FREE"] = "free";
    MEMORY_LABELS["USED"] = "used";
})(MEMORY_LABELS = exports.MEMORY_LABELS || (exports.MEMORY_LABELS = {}));
//# sourceMappingURL=enum.js.map