/**
 * Only call and return the result of `f` if `obj` is defined (not null nor
 * undefined)
 */
export declare function map<T, R>(obj: T | undefined | null, f: (t: T) => R): R | undefined;
export declare function isFunction(obj: unknown): obj is () => unknown;
export declare function fromEntries(arr: [string | undefined, unknown][]): Record<string, unknown>;
export declare function omit<T extends Record<string, unknown>, S extends keyof T>(t: T, ...keysToOmit: S[]): Omit<T, S>;
