import { Maybe, Nullable } from "./Maybe";
export declare function isIterable(obj: unknown): obj is Iterable<unknown>;
export declare function ifArray<T = unknown>(arr: T[] | unknown): Maybe<T[]>;
export declare function toArray<T>(arr: undefined | null | T[] | T | Iterable<T>): T[];
export declare function compact<T>(array: Nullable<T>[]): T[];
/**
 * Remove all elements from the given array that return false from the given
 * predicate `filter`.
 */
export declare function filterInPlace<T>(arr: T[], filter: (t: T) => boolean): T[];
export declare function uniq<T>(arr: T[]): T[];
export declare function shallowArrayEql(a: unknown[], b: unknown[]): boolean;
type Comparable = number | string | boolean;
/**
 * Returns a copy of arr, stable sorted by the given constraint. Note that false
 * < true, and that `f` may return an array for sort priorities, or undefined if
 * the item should be skipped from the returned result.
 *
 * Note: localeSort() thinks lower case should come before upper case (!!)
 */
export declare function sortBy<T>(arr: Iterable<Maybe<T>> | Maybe<T>[], f: (t: T) => Maybe<Comparable>): T[];
export declare function leastBy<T>(haystack: T[], f: (t: T) => Maybe<Comparable>): Maybe<T>;
export {};
