import { DateTime, Zone, ZoneOptions } from "luxon";
import { Maybe } from "./Maybe";
/**
 * Encodes an ExifTime (which may not have a timezone offset)
 */
export declare class ExifTime {
    #private;
    readonly hour: number;
    readonly minute: number;
    readonly second: number;
    readonly millisecond?: number | undefined;
    readonly rawValue?: string | undefined;
    readonly inferredZone?: boolean | undefined;
    static fromEXIF(text: string, defaultZone?: Maybe<string>): Maybe<ExifTime>;
    static fromDateTime(dt: Maybe<DateTime>, rawValue?: string, zone?: string, inferredZone?: boolean, unsetMilliseconds?: boolean): Maybe<ExifTime>;
    readonly zone: Maybe<string>;
    constructor(hour: number, minute: number, second: number, millisecond?: number | undefined, rawValue?: string | undefined, zoneName?: Maybe<string>, inferredZone?: boolean | undefined);
    toDateTime(): DateTime;
    /**
     * Alias for `.millisecond`
     */
    get millis(): number | undefined;
    get hasZone(): boolean;
    toString(): string;
    toISOString(): string;
    toExifString(): string;
    setZone(zone: string | Zone, opts?: ZoneOptions): Maybe<ExifTime>;
    toJSON(): {
        _ctor: string;
        hour: number;
        minute: number;
        second: number;
        millisecond: number | undefined;
        rawValue: string | undefined;
        zone: Maybe<string>;
        inferredZone: boolean | undefined;
    };
    static fromJSON(json: ReturnType<ExifTime["toJSON"]>): ExifTime;
}
