export type Maybe<T> = T | undefined;
export type Nullable<T> = T | undefined | null;
export type MaybeNull<T> = Nullable<T>;
export declare function map<T, U>(maybeT: Nullable<T>, f: (t: T) => U): Maybe<U>;
export declare function map2<A, B, U>(a: Nullable<A>, b: Nullable<B>, f: (a: A, b: B) => U): Maybe<U>;
export declare function first<T, U>(iter: Iterable<Maybe<T>>, f: (t: T) => Maybe<U>): Maybe<U>;
export declare function firstDefinedThunk<T>(iter: Iterable<() => Maybe<T>>): Maybe<T>;
/**
 * Convert functions that return `type | null` to `type | undefined`
 */
export declare function denull<T>(t: T | null): Maybe<T>;
