import { Nullable } from "./Maybe";
export declare function isObject(obj: unknown): obj is object;
export declare function keys<T extends object, K extends string & keyof T>(o: T): K[];
export declare function isFunction(obj: unknown): obj is (...args: unknown[]) => unknown;
/**
 * Turns an array of `[key, value]` pairs into an object.
 *
 *  - Pairs whose key is `null | undefined` **or** value is `undefined` are skipped.
 *  - If `base` is provided it is mutated and returned (handy for “extend” use‑cases).
 */
export declare function fromEntries<K extends PropertyKey, V = unknown>(pairs: Nullable<Nullable<[Nullable<K>, V]>[]>, base?: Record<K, V>): Record<K, V>;
export type Unpick<T, U> = {
    [P in keyof T]: P extends U ? never : T[P];
};
export declare function omit<T extends object, S extends string>(t: T, ...keysToOmit: S[]): Unpick<T, S>;
/**
 * Provides a type-safe exhaustive array of keys for a given interface.
 *
 * Unfortunately, `satisfies (keyof T)[]` doesn't ensure all keys are present,
 * and doesn't guard against duplicates. This function does.
 *
 * @param t - The interface to extract keys from. This is a Record of keys to
 * `true`, which ensures the returned key array is unique.
 */
export declare function keysOf<T>(t: Required<Record<keyof T, true>>): (keyof T)[];
