"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VersionTask = void 0;
const ExifToolTask_1 = require("./ExifToolTask");
class VersionTask extends ExifToolTask_1.ExifToolTask {
    static versionRegex = /^\d{1,3}\.\d{1,3}(?:\.\d{1,3})?$/;
    constructor(options) {
        super(["-ver"], options);
    }
    parse(input) {
        const value = input.trim();
        if (VersionTask.versionRegex.test(value)) {
            return value;
        }
        else {
            throw new Error(`Unexpected version ${value}`);
        }
    }
}
exports.VersionTask = VersionTask;
//# sourceMappingURL=VersionTask.js.map