export type StringMapper = (str: string) => string;
/**
 * Creates a function that transforms camel case strings to snake case.
 */
export declare function createSnakeCaseMapper({ upperCase, underscoreBeforeDigits, underscoreBetweenUppercaseLetters, }?: {
    upperCase?: boolean | undefined;
    underscoreBeforeDigits?: boolean | undefined;
    underscoreBetweenUppercaseLetters?: boolean | undefined;
}): StringMapper;
/**
 * Creates a function that transforms snake case strings to camel case.
 */
export declare function createCamelCaseMapper({ upperCase, }?: {
    upperCase?: boolean | undefined;
}): StringMapper;
