import { DynamicModule, Type } from '@nestjs/common';
import { ClsModuleAsyncOptions, ClsModuleOptions } from '../cls.options';
import { ClsPlugin } from '../plugin/cls-plugin.interface';
import { ClsModuleProxyProviderOptions } from '../proxy-provider/proxy-provider.interfaces';
/**
 * ClsModule is the main entry point for configuring the CLS module.
 */
export declare class ClsModule {
    /**
     * Configures the CLS module for root.
     *
     * Provides the `ClsService` and registered Proxy Providers for injection.
     */
    static forRoot(options?: ClsModuleOptions): DynamicModule;
    /**
     * Configures the CLS module in the root with asynchronously provided configuration.
     *
     * Provides the `ClsService` and registered Proxy Providers for injection.
     */
    static forRootAsync(asyncOptions: ClsModuleAsyncOptions): DynamicModule;
    /**
     * Provides the `ClsService` for injection.
     */
    static forFeature(): DynamicModule;
    /**
     * Registers the given Class proxy providers in the module for injection along with `ClsService`.
     *
     * For advanced options, use `forFeatureAsync`.
     */
    static forFeature(...proxyProviderClasses: Array<Type>): DynamicModule;
    /**
     * Registers the given Class or Factory proxy providers in the module along with `ClsService`.
     *
     * If used with `global: true`, makes the proxy provider available globally.
     */
    static forFeatureAsync(options: ClsModuleProxyProviderOptions): DynamicModule;
    /**
     * Registers the given Plugins the module along with `ClsService`.
     */
    static registerPlugins(plugins: ClsPlugin[]): DynamicModule;
}
//# sourceMappingURL=cls.module.d.ts.map