"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CLS_ID = exports.CLS_CTX = exports.CLS_RES = exports.CLS_REQ = void 0;
/**
 * Symbol for the Request object stored in the CLS context.
 *
 * Only available in the CLS if the `saveReq` option of `middleware` (`ClsMiddleware`) options
 * is set to `true` (default).
 */
exports.CLS_REQ = Symbol('CLS_REQ');
/**
 * Symbol for the Response object stored in the CLS context.
 *
 * Only available in the CLS if the `saveRes` option of `middleware` (`ClsMiddleware`) options
 * is set to `true` (default is `false`).
 */
exports.CLS_RES = Symbol('CLS_RES');
/**
 * Symbol for the CLS ExecutionContext object stored in the CLS context.
 *
 * Only available if the `saveCtx` options of either `interceptor` (ClsInterceptor) or
 * `guard` (ClsGuard) options is set to `true` (default).
 */
exports.CLS_CTX = Symbol('CLS_CTX');
/**
 * Symbol for the ID of the CLS context stored in the CLS context.
 *
 * Only available in the CLS if the `generateId` option is set to `true` (default is `false`)
 *
 * Also available via `cls.getId()`
 */
exports.CLS_ID = Symbol('CLS_ID');
//# sourceMappingURL=cls.constants.js.map