"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DisableMaintenanceModeCommand = exports.EnableMaintenanceModeCommand = void 0;
const nest_commander_1 = require("nest-commander");
const cli_service_1 = require("../services/cli.service");
let EnableMaintenanceModeCommand = class EnableMaintenanceModeCommand extends nest_commander_1.CommandRunner {
    service;
    constructor(service) {
        super();
        this.service = service;
    }
    async run() {
        const { authUrl, alreadyEnabled } = await this.service.enableMaintenanceMode();
        console.info(alreadyEnabled ? 'The server is already in maintenance mode!' : 'Maintenance mode has been enabled.');
        console.info(`\nLog in using the following URL:\n${authUrl}`);
    }
};
exports.EnableMaintenanceModeCommand = EnableMaintenanceModeCommand;
exports.EnableMaintenanceModeCommand = EnableMaintenanceModeCommand = __decorate([
    (0, nest_commander_1.Command)({
        name: 'enable-maintenance-mode',
        description: 'Enable maintenance mode or regenerate the maintenance token',
    }),
    __metadata("design:paramtypes", [cli_service_1.CliService])
], EnableMaintenanceModeCommand);
let DisableMaintenanceModeCommand = class DisableMaintenanceModeCommand extends nest_commander_1.CommandRunner {
    service;
    constructor(service) {
        super();
        this.service = service;
    }
    async run() {
        const { alreadyDisabled } = await this.service.disableMaintenanceMode();
        console.log(alreadyDisabled ? 'The server is already out of maintenance mode!' : 'Maintenance mode has been disabled.');
    }
};
exports.DisableMaintenanceModeCommand = DisableMaintenanceModeCommand;
exports.DisableMaintenanceModeCommand = DisableMaintenanceModeCommand = __decorate([
    (0, nest_commander_1.Command)({
        name: 'disable-maintenance-mode',
        description: 'Disable maintenance mode',
    }),
    __metadata("design:paramtypes", [cli_service_1.CliService])
], DisableMaintenanceModeCommand);
//# sourceMappingURL=maintenance-mode.js.map