import { CreateLibraryDto, LibraryResponseDto, LibraryStatsResponseDto, UpdateLibraryDto, ValidateLibraryDto, ValidateLibraryResponseDto } from 'src/dtos/library.dto';
import { LibraryService } from 'src/services/library.service';
import { UUIDParamDto } from 'src/validation';
export declare class LibraryController {
    private service;
    constructor(service: LibraryService);
    getAllLibraries(): Promise<LibraryResponseDto[]>;
    createLibrary(dto: CreateLibraryDto): Promise<LibraryResponseDto>;
    getLibrary({ id }: UUIDParamDto): Promise<LibraryResponseDto>;
    updateLibrary({ id }: UUIDParamDto, dto: UpdateLibraryDto): Promise<LibraryResponseDto>;
    deleteLibrary({ id }: UUIDParamDto): Promise<void>;
    validate({ id }: UUIDParamDto, dto: ValidateLibraryDto): Promise<ValidateLibraryResponseDto>;
    getLibraryStatistics({ id }: UUIDParamDto): Promise<LibraryStatsResponseDto>;
    scanLibrary({ id }: UUIDParamDto): Promise<void>;
}
