"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MaintenanceController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const auth_dto_1 = require("../dtos/auth.dto");
const maintenance_dto_1 = require("../dtos/maintenance.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const maintenance_service_1 = require("../services/maintenance.service");
const response_1 = require("../utils/response");
let MaintenanceController = class MaintenanceController {
    service;
    constructor(service) {
        this.service = service;
    }
    maintenanceLogin(_dto) {
        throw new common_1.BadRequestException('Not in maintenance mode');
    }
    async setMaintenanceMode(auth, dto, loginDetails, res) {
        if (dto.action === enum_1.MaintenanceAction.Start) {
            const { jwt } = await this.service.startMaintenance(auth.user.name);
            return (0, response_1.respondWithCookie)(res, undefined, {
                isSecure: loginDetails.isSecure,
                values: [{ key: enum_1.ImmichCookie.MaintenanceToken, value: jwt }],
            });
        }
    }
};
exports.MaintenanceController = MaintenanceController;
__decorate([
    (0, common_1.Post)('login'),
    (0, decorators_1.Endpoint)({
        summary: 'Log into maintenance mode',
        description: 'Login with maintenance token or cookie to receive current information and perform further actions.',
        history: new decorators_1.HistoryBuilder().added('v2.3.0').alpha('v2.3.0'),
    }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/maintenance.dto").MaintenanceAuthDto }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [maintenance_dto_1.MaintenanceLoginDto]),
    __metadata("design:returntype", maintenance_dto_1.MaintenanceAuthDto)
], MaintenanceController.prototype, "maintenanceLogin", null);
__decorate([
    (0, common_1.Post)(),
    (0, decorators_1.Endpoint)({
        summary: 'Set maintenance mode',
        description: 'Put Immich into or take it out of maintenance mode',
        history: new decorators_1.HistoryBuilder().added('v2.3.0').alpha('v2.3.0'),
    }),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.Maintenance, admin: true }),
    openapi.ApiResponse({ status: 201 }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, auth_guard_1.GetLoginDetails)()),
    __param(3, (0, common_1.Res)({ passthrough: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        maintenance_dto_1.SetMaintenanceModeDto, Object, Object]),
    __metadata("design:returntype", Promise)
], MaintenanceController.prototype, "setMaintenanceMode", null);
exports.MaintenanceController = MaintenanceController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.Maintenance),
    (0, common_1.Controller)('admin/maintenance'),
    __metadata("design:paramtypes", [maintenance_service_1.MaintenanceService])
], MaintenanceController);
//# sourceMappingURL=maintenance.controller.js.map