import { NextFunction, Response } from 'express';
import { BulkIdResponseDto, BulkIdsDto } from 'src/dtos/asset-ids.response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { AssetFaceUpdateDto, MergePersonDto, PeopleResponseDto, PeopleUpdateDto, PersonCreateDto, PersonResponseDto, PersonSearchDto, PersonStatisticsResponseDto, PersonUpdateDto } from 'src/dtos/person.dto';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { PersonService } from 'src/services/person.service';
import { UUIDParamDto } from 'src/validation';
export declare class PersonController {
    private service;
    private logger;
    constructor(service: PersonService, logger: LoggingRepository);
    getAllPeople(auth: AuthDto, options: PersonSearchDto): Promise<PeopleResponseDto>;
    createPerson(auth: AuthDto, dto: PersonCreateDto): Promise<PersonResponseDto>;
    updatePeople(auth: AuthDto, dto: PeopleUpdateDto): Promise<BulkIdResponseDto[]>;
    deletePeople(auth: AuthDto, dto: BulkIdsDto): Promise<void>;
    getPerson(auth: AuthDto, { id }: UUIDParamDto): Promise<PersonResponseDto>;
    updatePerson(auth: AuthDto, { id }: UUIDParamDto, dto: PersonUpdateDto): Promise<PersonResponseDto>;
    deletePerson(auth: AuthDto, { id }: UUIDParamDto): Promise<void>;
    getPersonStatistics(auth: AuthDto, { id }: UUIDParamDto): Promise<PersonStatisticsResponseDto>;
    getPersonThumbnail(res: Response, next: NextFunction, auth: AuthDto, { id }: UUIDParamDto): Promise<void>;
    reassignFaces(auth: AuthDto, { id }: UUIDParamDto, dto: AssetFaceUpdateDto): Promise<PersonResponseDto[]>;
    mergePerson(auth: AuthDto, { id }: UUIDParamDto, dto: MergePersonDto): Promise<BulkIdResponseDto[]>;
}
