"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapMemory = exports.MemoryResponseDto = exports.MemoryStatisticsResponseDto = exports.MemoryCreateDto = exports.MemoryUpdateDto = exports.MemorySearchDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const asset_response_dto_1 = require("./asset-response.dto");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class MemoryBaseDto {
    isSaved;
    seenAt;
    static _OPENAPI_METADATA_FACTORY() {
        return { isSaved: { required: false, type: () => Boolean }, seenAt: { required: false, type: () => Date } };
    }
}
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], MemoryBaseDto.prototype, "isSaved", void 0);
__decorate([
    (0, validation_1.ValidateDate)({ optional: true }),
    __metadata("design:type", Date)
], MemoryBaseDto.prototype, "seenAt", void 0);
class MemorySearchDto {
    type;
    for;
    isTrashed;
    isSaved;
    size;
    order;
    static _OPENAPI_METADATA_FACTORY() {
        return { type: { required: false, type: () => String, enum: require("../enum").MemoryType }, for: { required: false, type: () => Date }, isTrashed: { required: false, type: () => Boolean }, isSaved: { required: false, type: () => Boolean }, size: { required: false, type: () => Number, minimum: 1 }, order: { required: false, enum: require("../enum").AssetOrderWithRandom } };
    }
}
exports.MemorySearchDto = MemorySearchDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.MemoryType, name: 'MemoryType', optional: true }),
    __metadata("design:type", String)
], MemorySearchDto.prototype, "type", void 0);
__decorate([
    (0, validation_1.ValidateDate)({ optional: true }),
    __metadata("design:type", Date)
], MemorySearchDto.prototype, "for", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], MemorySearchDto.prototype, "isTrashed", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], MemorySearchDto.prototype, "isSaved", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, validation_1.Optional)(),
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of memories to return' }),
    __metadata("design:type", Number)
], MemorySearchDto.prototype, "size", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AssetOrderWithRandom, name: 'MemorySearchOrder', optional: true }),
    __metadata("design:type", String)
], MemorySearchDto.prototype, "order", void 0);
class OnThisDayDto {
    year;
    static _OPENAPI_METADATA_FACTORY() {
        return { year: { required: true, type: () => Number, minimum: 1 } };
    }
}
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    __metadata("design:type", Number)
], OnThisDayDto.prototype, "year", void 0);
class MemoryUpdateDto extends MemoryBaseDto {
    memoryAt;
    static _OPENAPI_METADATA_FACTORY() {
        return { memoryAt: { required: false, type: () => Date } };
    }
}
exports.MemoryUpdateDto = MemoryUpdateDto;
__decorate([
    (0, validation_1.ValidateDate)({ optional: true }),
    __metadata("design:type", Date)
], MemoryUpdateDto.prototype, "memoryAt", void 0);
class MemoryCreateDto extends MemoryBaseDto {
    type;
    data;
    memoryAt;
    assetIds;
    static _OPENAPI_METADATA_FACTORY() {
        return { type: { required: true, type: () => String, enum: require("../enum").MemoryType }, data: { required: true, type: () => OnThisDayDto }, memoryAt: { required: true, type: () => Date }, assetIds: { required: false, type: () => [String] } };
    }
}
exports.MemoryCreateDto = MemoryCreateDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.MemoryType, name: 'MemoryType' }),
    __metadata("design:type", String)
], MemoryCreateDto.prototype, "type", void 0);
__decorate([
    (0, class_validator_1.IsObject)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)((options) => {
        switch (options?.object.type) {
            case enum_1.MemoryType.OnThisDay: {
                return OnThisDayDto;
            }
            default: {
                return Object;
            }
        }
    }),
    __metadata("design:type", Object)
], MemoryCreateDto.prototype, "data", void 0);
__decorate([
    (0, validation_1.ValidateDate)(),
    __metadata("design:type", Date)
], MemoryCreateDto.prototype, "memoryAt", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, each: true }),
    __metadata("design:type", Array)
], MemoryCreateDto.prototype, "assetIds", void 0);
class MemoryStatisticsResponseDto {
    total;
    static _OPENAPI_METADATA_FACTORY() {
        return { total: { required: true, type: () => Number } };
    }
}
exports.MemoryStatisticsResponseDto = MemoryStatisticsResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], MemoryStatisticsResponseDto.prototype, "total", void 0);
class MemoryResponseDto {
    id;
    createdAt;
    updatedAt;
    deletedAt;
    memoryAt;
    seenAt;
    showAt;
    hideAt;
    ownerId;
    type;
    data;
    isSaved;
    assets;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, createdAt: { required: true, type: () => Date }, updatedAt: { required: true, type: () => Date }, deletedAt: { required: false, type: () => Date }, memoryAt: { required: true, type: () => Date }, seenAt: { required: false, type: () => Date }, showAt: { required: false, type: () => Date }, hideAt: { required: false, type: () => Date }, ownerId: { required: true, type: () => String }, type: { required: true, type: () => String, enum: require("../enum").MemoryType }, data: { required: true, type: () => OnThisDayDto }, isSaved: { required: true, type: () => Boolean }, assets: { required: true, type: () => [require("./asset-response.dto").AssetResponseDto] } };
    }
}
exports.MemoryResponseDto = MemoryResponseDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.MemoryType, name: 'MemoryType' }),
    __metadata("design:type", String)
], MemoryResponseDto.prototype, "type", void 0);
const mapMemory = (entity, auth) => {
    return {
        id: entity.id,
        createdAt: entity.createdAt,
        updatedAt: entity.updatedAt,
        deletedAt: entity.deletedAt ?? undefined,
        memoryAt: entity.memoryAt,
        seenAt: entity.seenAt ?? undefined,
        showAt: entity.showAt ?? undefined,
        hideAt: entity.hideAt ?? undefined,
        ownerId: entity.ownerId,
        type: entity.type,
        data: entity.data,
        isSaved: entity.isSaved,
        assets: ('assets' in entity ? entity.assets : []).map((asset) => (0, asset_response_dto_1.mapAsset)(asset, { auth })),
    };
};
exports.mapMemory = mapMemory;
//# sourceMappingURL=memory.dto.js.map