"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapSession = exports.SessionCreateResponseDto = exports.SessionResponseDto = exports.SessionUpdateDto = exports.SessionCreateDto = void 0;
const openapi = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const validation_1 = require("../validation");
class SessionCreateDto {
    duration;
    deviceType;
    deviceOS;
    static _OPENAPI_METADATA_FACTORY() {
        return { duration: { required: false, type: () => Number, description: "session duration, in seconds", minimum: 1 }, deviceType: { required: false, type: () => String }, deviceOS: { required: false, type: () => String } };
    }
}
exports.SessionCreateDto = SessionCreateDto;
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", Number)
], SessionCreateDto.prototype, "duration", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], SessionCreateDto.prototype, "deviceType", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], SessionCreateDto.prototype, "deviceOS", void 0);
class SessionUpdateDto {
    isPendingSyncReset;
    static _OPENAPI_METADATA_FACTORY() {
        return { isPendingSyncReset: { required: false } };
    }
}
exports.SessionUpdateDto = SessionUpdateDto;
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    (0, class_validator_1.Equals)(true),
    __metadata("design:type", Boolean)
], SessionUpdateDto.prototype, "isPendingSyncReset", void 0);
class SessionResponseDto {
    id;
    createdAt;
    updatedAt;
    expiresAt;
    current;
    deviceType;
    deviceOS;
    appVersion;
    isPendingSyncReset;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, createdAt: { required: true, type: () => String }, updatedAt: { required: true, type: () => String }, expiresAt: { required: false, type: () => String }, current: { required: true, type: () => Boolean }, deviceType: { required: true, type: () => String }, deviceOS: { required: true, type: () => String }, appVersion: { required: true, type: () => String, nullable: true }, isPendingSyncReset: { required: true, type: () => Boolean } };
    }
}
exports.SessionResponseDto = SessionResponseDto;
class SessionCreateResponseDto extends SessionResponseDto {
    token;
    static _OPENAPI_METADATA_FACTORY() {
        return { token: { required: true, type: () => String } };
    }
}
exports.SessionCreateResponseDto = SessionCreateResponseDto;
const mapSession = (entity, currentId) => ({
    id: entity.id,
    createdAt: entity.createdAt.toISOString(),
    updatedAt: entity.updatedAt.toISOString(),
    expiresAt: entity.expiresAt?.toISOString(),
    current: currentId === entity.id,
    appVersion: entity.appVersion,
    deviceOS: entity.deviceOS,
    deviceType: entity.deviceType,
    isPendingSyncReset: entity.isPendingSyncReset,
});
exports.mapSession = mapSession;
//# sourceMappingURL=session.dto.js.map