"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MaintenanceWorkerController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const maintenance_dto_1 = require("../dtos/maintenance.dto");
const enum_1 = require("../enum");
const maintenance_auth_guard_1 = require("./maintenance-auth.guard");
const maintenance_worker_service_1 = require("./maintenance-worker.service");
const auth_guard_1 = require("../middleware/auth.guard");
const response_1 = require("../utils/response");
let MaintenanceWorkerController = class MaintenanceWorkerController {
    service;
    constructor(service) {
        this.service = service;
    }
    getServerConfig() {
        return this.service.getSystemConfig();
    }
    async maintenanceLogin(request, dto, loginDetails, res) {
        const token = dto.token ?? request.cookies[enum_1.ImmichCookie.MaintenanceToken];
        const auth = await this.service.login(token);
        return (0, response_1.respondWithCookie)(res, auth, {
            isSecure: loginDetails.isSecure,
            values: [{ key: enum_1.ImmichCookie.MaintenanceToken, value: token }],
        });
    }
    async setMaintenanceMode(dto) {
        if (dto.action === enum_1.MaintenanceAction.End) {
            await this.service.endMaintenance();
        }
    }
};
exports.MaintenanceWorkerController = MaintenanceWorkerController;
__decorate([
    (0, common_1.Get)('server/config'),
    openapi.ApiResponse({ status: 200, type: require("../dtos/server.dto").ServerConfigDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], MaintenanceWorkerController.prototype, "getServerConfig", null);
__decorate([
    (0, common_1.Post)('admin/maintenance/login'),
    openapi.ApiResponse({ status: 201, type: require("../dtos/maintenance.dto").MaintenanceAuthDto }),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, auth_guard_1.GetLoginDetails)()),
    __param(3, (0, common_1.Res)({ passthrough: true })),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, maintenance_dto_1.MaintenanceLoginDto, Object, Object]),
    __metadata("design:returntype", Promise)
], MaintenanceWorkerController.prototype, "maintenanceLogin", null);
__decorate([
    (0, common_1.Post)('admin/maintenance'),
    (0, maintenance_auth_guard_1.MaintenanceRoute)(),
    openapi.ApiResponse({ status: 201 }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [maintenance_dto_1.SetMaintenanceModeDto]),
    __metadata("design:returntype", Promise)
], MaintenanceWorkerController.prototype, "setMaintenanceMode", null);
exports.MaintenanceWorkerController = MaintenanceWorkerController = __decorate([
    (0, common_1.Controller)(),
    __metadata("design:paramtypes", [maintenance_worker_service_1.MaintenanceWorkerService])
], MaintenanceWorkerController);
//# sourceMappingURL=maintenance-worker.controller.js.map