"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const database_1 = require("../utils/database");
class ActivityAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, activityIds) {
        if (activityIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('activity')
            .select('activity.id')
            .where('activity.id', 'in', [...activityIds])
            .where('activity.userId', '=', userId)
            .execute()
            .then((activities) => new Set(activities.map((activity) => activity.id)));
    }
    async checkAlbumOwnerAccess(userId, activityIds) {
        if (activityIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('activity')
            .select('activity.id')
            .leftJoin('album', (join) => join.onRef('activity.albumId', '=', 'album.id').on('album.deletedAt', 'is', null))
            .where('activity.id', 'in', [...activityIds])
            .whereRef('album.ownerId', '=', (0, database_1.asUuid)(userId))
            .execute()
            .then((activities) => new Set(activities.map((activity) => activity.id)));
    }
    async checkCreateAccess(userId, albumIds) {
        if (albumIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('album')
            .select('album.id')
            .leftJoin('album_user as albumUsers', 'albumUsers.albumId', 'album.id')
            .leftJoin('user', (join) => join.onRef('user.id', '=', 'albumUsers.userId').on('user.deletedAt', 'is', null))
            .where('album.id', 'in', [...albumIds])
            .where('album.isActivityEnabled', '=', true)
            .where((eb) => eb.or([eb('album.ownerId', '=', userId), eb('user.id', '=', userId)]))
            .where('album.deletedAt', 'is', null)
            .execute()
            .then((albums) => new Set(albums.map((album) => album.id)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], ActivityAccess.prototype, "checkOwnerAccess", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], ActivityAccess.prototype, "checkAlbumOwnerAccess", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], ActivityAccess.prototype, "checkCreateAccess", null);
class AlbumAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, albumIds) {
        if (albumIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('album')
            .select('album.id')
            .where('album.id', 'in', [...albumIds])
            .where('album.ownerId', '=', userId)
            .where('album.deletedAt', 'is', null)
            .execute()
            .then((albums) => new Set(albums.map((album) => album.id)));
    }
    async checkSharedAlbumAccess(userId, albumIds, access) {
        if (albumIds.size === 0) {
            return new Set();
        }
        const accessRole = access === enum_1.AlbumUserRole.Editor ? [enum_1.AlbumUserRole.Editor] : [enum_1.AlbumUserRole.Editor, enum_1.AlbumUserRole.Viewer];
        return this.db
            .selectFrom('album')
            .select('album.id')
            .leftJoin('album_user', 'album_user.albumId', 'album.id')
            .leftJoin('user', (join) => join.onRef('user.id', '=', 'album_user.userId').on('user.deletedAt', 'is', null))
            .where('album.id', 'in', [...albumIds])
            .where('album.deletedAt', 'is', null)
            .where('user.id', '=', userId)
            .where('album_user.role', 'in', [...accessRole])
            .execute()
            .then((albums) => new Set(albums.map((album) => album.id)));
    }
    async checkSharedLinkAccess(sharedLinkId, albumIds) {
        if (albumIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('shared_link')
            .select('shared_link.albumId')
            .where('shared_link.id', '=', sharedLinkId)
            .where('shared_link.albumId', 'in', [...albumIds])
            .execute()
            .then((sharedLinks) => new Set(sharedLinks.flatMap((sharedLink) => (sharedLink.albumId ? [sharedLink.albumId] : []))));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], AlbumAccess.prototype, "checkOwnerAccess", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set, String]),
    __metadata("design:returntype", Promise)
], AlbumAccess.prototype, "checkSharedAlbumAccess", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], AlbumAccess.prototype, "checkSharedLinkAccess", null);
class AssetAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkAlbumAccess(userId, assetIds) {
        if (assetIds.size === 0) {
            return new Set();
        }
        return this.db
            .with('target', (qb) => qb.selectNoFrom((0, kysely_1.sql) `array[${kysely_1.sql.join([...assetIds])}]::uuid[]`.as('ids')))
            .selectFrom('album')
            .innerJoin('album_asset as albumAssets', 'album.id', 'albumAssets.albumId')
            .innerJoin('asset', (join) => join.onRef('asset.id', '=', 'albumAssets.assetId').on('asset.deletedAt', 'is', null))
            .leftJoin('album_user as albumUsers', 'albumUsers.albumId', 'album.id')
            .leftJoin('user', (join) => join.onRef('user.id', '=', 'albumUsers.userId').on('user.deletedAt', 'is', null))
            .crossJoin('target')
            .select(['asset.id', 'asset.livePhotoVideoId'])
            .where((eb) => eb.or([
            eb('asset.id', '=', (0, kysely_1.sql) `any(target.ids)`),
            eb('asset.livePhotoVideoId', '=', (0, kysely_1.sql) `any(target.ids)`),
        ]))
            .where((eb) => eb.or([eb('album.ownerId', '=', userId), eb('user.id', '=', userId)]))
            .where('album.deletedAt', 'is', null)
            .execute()
            .then((assets) => {
            const allowedIds = new Set();
            for (const asset of assets) {
                if (asset.id && assetIds.has(asset.id)) {
                    allowedIds.add(asset.id);
                }
                if (asset.livePhotoVideoId && assetIds.has(asset.livePhotoVideoId)) {
                    allowedIds.add(asset.livePhotoVideoId);
                }
            }
            return allowedIds;
        });
    }
    async checkOwnerAccess(userId, assetIds, hasElevatedPermission) {
        if (assetIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('asset')
            .select('asset.id')
            .where('asset.id', 'in', [...assetIds])
            .where('asset.ownerId', '=', userId)
            .$if(!hasElevatedPermission, (eb) => eb.where('asset.visibility', '!=', enum_1.AssetVisibility.Locked))
            .execute()
            .then((assets) => new Set(assets.map((asset) => asset.id)));
    }
    async checkPartnerAccess(userId, assetIds) {
        if (assetIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('partner')
            .innerJoin('user as sharedBy', (join) => join.onRef('sharedBy.id', '=', 'partner.sharedById').on('sharedBy.deletedAt', 'is', null))
            .innerJoin('asset', (join) => join.onRef('asset.ownerId', '=', 'sharedBy.id').on('asset.deletedAt', 'is', null))
            .select('asset.id')
            .where('partner.sharedWithId', '=', userId)
            .where((eb) => eb.or([
            eb('asset.visibility', '=', kysely_1.sql.lit(enum_1.AssetVisibility.Timeline)),
            eb('asset.visibility', '=', kysely_1.sql.lit(enum_1.AssetVisibility.Hidden)),
        ]))
            .where('asset.id', 'in', [...assetIds])
            .execute()
            .then((assets) => new Set(assets.map((asset) => asset.id)));
    }
    async checkSharedLinkAccess(sharedLinkId, assetIds) {
        if (assetIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('shared_link')
            .leftJoin('album', (join) => join.onRef('album.id', '=', 'shared_link.albumId').on('album.deletedAt', 'is', null))
            .leftJoin('shared_link_asset', 'shared_link_asset.sharedLinkId', 'shared_link.id')
            .leftJoin('asset', (join) => join.onRef('asset.id', '=', 'shared_link_asset.assetId').on('asset.deletedAt', 'is', null))
            .leftJoin('album_asset', 'album_asset.albumId', 'album.id')
            .leftJoin('asset as albumAssets', (join) => join.onRef('albumAssets.id', '=', 'album_asset.assetId').on('albumAssets.deletedAt', 'is', null))
            .select([
            'asset.id as assetId',
            'asset.livePhotoVideoId as assetLivePhotoVideoId',
            'albumAssets.id as albumAssetId',
            'albumAssets.livePhotoVideoId as albumAssetLivePhotoVideoId',
        ])
            .where('shared_link.id', '=', sharedLinkId)
            .where((0, kysely_1.sql) `array["asset"."id", "asset"."livePhotoVideoId", "albumAssets"."id", "albumAssets"."livePhotoVideoId"]`, '&&', (0, kysely_1.sql) `array[${kysely_1.sql.join([...assetIds])}]::uuid[] `)
            .execute()
            .then((rows) => {
            const allowedIds = new Set();
            for (const row of rows) {
                if (row.assetId && assetIds.has(row.assetId)) {
                    allowedIds.add(row.assetId);
                }
                if (row.assetLivePhotoVideoId && assetIds.has(row.assetLivePhotoVideoId)) {
                    allowedIds.add(row.assetLivePhotoVideoId);
                }
                if (row.albumAssetId && assetIds.has(row.albumAssetId)) {
                    allowedIds.add(row.albumAssetId);
                }
                if (row.albumAssetLivePhotoVideoId && assetIds.has(row.albumAssetLivePhotoVideoId)) {
                    allowedIds.add(row.albumAssetLivePhotoVideoId);
                }
            }
            return allowedIds;
        });
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], AssetAccess.prototype, "checkAlbumAccess", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set, Object]),
    __metadata("design:returntype", Promise)
], AssetAccess.prototype, "checkOwnerAccess", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], AssetAccess.prototype, "checkPartnerAccess", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], AssetAccess.prototype, "checkSharedLinkAccess", null);
class AuthDeviceAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, deviceIds) {
        if (deviceIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('session')
            .select('session.id')
            .where('session.userId', '=', userId)
            .where('session.id', 'in', [...deviceIds])
            .execute()
            .then((tokens) => new Set(tokens.map((token) => token.id)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], AuthDeviceAccess.prototype, "checkOwnerAccess", null);
class NotificationAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, notificationIds) {
        if (notificationIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('notification')
            .select('notification.id')
            .where('notification.id', 'in', [...notificationIds])
            .where('notification.userId', '=', userId)
            .execute()
            .then((stacks) => new Set(stacks.map((stack) => stack.id)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], NotificationAccess.prototype, "checkOwnerAccess", null);
class SessionAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, sessionIds) {
        if (sessionIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('session')
            .select('session.id')
            .where('session.id', 'in', [...sessionIds])
            .where('session.userId', '=', userId)
            .execute()
            .then((sessions) => new Set(sessions.map((session) => session.id)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], SessionAccess.prototype, "checkOwnerAccess", null);
class StackAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, stackIds) {
        if (stackIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('stack')
            .select('stack.id')
            .where('stack.id', 'in', [...stackIds])
            .where('stack.ownerId', '=', userId)
            .execute()
            .then((stacks) => new Set(stacks.map((stack) => stack.id)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], StackAccess.prototype, "checkOwnerAccess", null);
class TimelineAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkPartnerAccess(userId, partnerIds) {
        if (partnerIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('partner')
            .select('partner.sharedById')
            .where('partner.sharedById', 'in', [...partnerIds])
            .where('partner.sharedWithId', '=', userId)
            .execute()
            .then((partners) => new Set(partners.map((partner) => partner.sharedById)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], TimelineAccess.prototype, "checkPartnerAccess", null);
class MemoryAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, memoryIds) {
        if (memoryIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('memory')
            .select('memory.id')
            .where('memory.id', 'in', [...memoryIds])
            .where('memory.ownerId', '=', userId)
            .where('memory.deletedAt', 'is', null)
            .execute()
            .then((memories) => new Set(memories.map((memory) => memory.id)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], MemoryAccess.prototype, "checkOwnerAccess", null);
class PersonAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, personIds) {
        if (personIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('person')
            .select('person.id')
            .where('person.id', 'in', [...personIds])
            .where('person.ownerId', '=', userId)
            .execute()
            .then((persons) => new Set(persons.map((person) => person.id)));
    }
    async checkFaceOwnerAccess(userId, assetFaceIds) {
        if (assetFaceIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('asset_face')
            .select('asset_face.id')
            .leftJoin('asset', (join) => join.onRef('asset.id', '=', 'asset_face.assetId').on('asset.deletedAt', 'is', null))
            .where('asset_face.id', 'in', [...assetFaceIds])
            .where('asset.ownerId', '=', userId)
            .execute()
            .then((faces) => new Set(faces.map((face) => face.id)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], PersonAccess.prototype, "checkOwnerAccess", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], PersonAccess.prototype, "checkFaceOwnerAccess", null);
class PartnerAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkUpdateAccess(userId, partnerIds) {
        if (partnerIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('partner')
            .select('partner.sharedById')
            .where('partner.sharedById', 'in', [...partnerIds])
            .where('partner.sharedWithId', '=', userId)
            .execute()
            .then((partners) => new Set(partners.map((partner) => partner.sharedById)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], PartnerAccess.prototype, "checkUpdateAccess", null);
class TagAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, tagIds) {
        if (tagIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('tag')
            .select('tag.id')
            .where('tag.id', 'in', [...tagIds])
            .where('tag.userId', '=', userId)
            .execute()
            .then((tags) => new Set(tags.map((tag) => tag.id)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], TagAccess.prototype, "checkOwnerAccess", null);
class WorkflowAccess {
    db;
    constructor(db) {
        this.db = db;
    }
    async checkOwnerAccess(userId, workflowIds) {
        if (workflowIds.size === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('workflow')
            .select('workflow.id')
            .where('workflow.id', 'in', [...workflowIds])
            .where('workflow.ownerId', '=', userId)
            .execute()
            .then((workflows) => new Set(workflows.map((workflow) => workflow.id)));
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID_SET] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Set]),
    __metadata("design:returntype", Promise)
], WorkflowAccess.prototype, "checkOwnerAccess", null);
let AccessRepository = class AccessRepository {
    activity;
    album;
    asset;
    authDevice;
    memory;
    notification;
    person;
    partner;
    session;
    stack;
    tag;
    timeline;
    workflow;
    constructor(db) {
        this.activity = new ActivityAccess(db);
        this.album = new AlbumAccess(db);
        this.asset = new AssetAccess(db);
        this.authDevice = new AuthDeviceAccess(db);
        this.memory = new MemoryAccess(db);
        this.notification = new NotificationAccess(db);
        this.person = new PersonAccess(db);
        this.partner = new PartnerAccess(db);
        this.session = new SessionAccess(db);
        this.stack = new StackAccess(db);
        this.tag = new TagAccess(db);
        this.timeline = new TimelineAccess(db);
        this.workflow = new WorkflowAccess(db);
    }
};
exports.AccessRepository = AccessRepository;
exports.AccessRepository = AccessRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], AccessRepository);
//# sourceMappingURL=access.repository.js.map