import { Insertable, Kysely, Selectable, Updateable, UpdateResult } from 'kysely';
import { Stack } from 'src/database';
import { AuthDto } from 'src/dtos/auth.dto';
import { AssetFileType, AssetMetadataKey, AssetOrder, AssetStatus, AssetType, AssetVisibility } from 'src/enum';
import { DB } from 'src/schema';
import { AssetExifTable } from 'src/schema/tables/asset-exif.table';
import { AssetFileTable } from 'src/schema/tables/asset-file.table';
import { AssetJobStatusTable } from 'src/schema/tables/asset-job-status.table';
import { AssetTable } from 'src/schema/tables/asset.table';
export type AssetStats = Record<AssetType, number>;
interface AssetStatsOptions {
    isFavorite?: boolean;
    isTrashed?: boolean;
    visibility?: AssetVisibility;
}
interface LivePhotoSearchOptions {
    ownerId: string;
    libraryId?: string | null;
    livePhotoCID: string;
    otherAssetId: string;
    type: AssetType;
}
interface AssetBuilderOptions {
    isFavorite?: boolean;
    isTrashed?: boolean;
    isDuplicate?: boolean;
    albumId?: string;
    tagId?: string;
    personId?: string;
    userIds?: string[];
    withStacked?: boolean;
    exifInfo?: boolean;
    status?: AssetStatus;
    assetType?: AssetType;
    visibility?: AssetVisibility;
    withCoordinates?: boolean;
}
export interface TimeBucketOptions extends AssetBuilderOptions {
    order?: AssetOrder;
}
export interface TimeBucketItem {
    timeBucket: string;
    count: number;
}
export interface YearMonthDay {
    day: number;
    month: number;
    year: number;
}
interface AssetExploreFieldOptions {
    maxFields: number;
    minAssetsPerField: number;
}
interface AssetFullSyncOptions {
    ownerId: string;
    lastId?: string;
    updatedUntil: Date;
    limit: number;
}
interface AssetDeltaSyncOptions {
    userIds: string[];
    updatedAfter: Date;
    limit: number;
}
interface AssetGetByChecksumOptions {
    ownerId: string;
    checksum: Buffer;
    libraryId?: string;
}
interface GetByIdsRelations {
    exifInfo?: boolean;
    faces?: {
        person?: boolean;
        withDeleted?: boolean;
    };
    files?: boolean;
    library?: boolean;
    owner?: boolean;
    smartSearch?: boolean;
    stack?: {
        assets?: boolean;
    };
    tags?: boolean;
}
export declare class AssetRepository {
    private db;
    constructor(db: Kysely<DB>);
    upsertExif(exif: Insertable<AssetExifTable>, { lockedPropertiesBehavior }: {
        lockedPropertiesBehavior: 'override' | 'append' | 'skip';
    }): Promise<void>;
    updateAllExif(ids: string[], options: Updateable<AssetExifTable>): Promise<void>;
    updateDateTimeOriginal(ids: string[], delta?: number, timeZone?: string): Promise<{
        assetId: string;
        dateTimeOriginal: Date | null;
        timeZone: string | null;
    }[]>;
    upsertJobStatus(...jobStatus: Insertable<AssetJobStatusTable>[]): Promise<void>;
    getMetadata(assetId: string): Promise<{
        key: AssetMetadataKey;
        value: object;
        updatedAt: Date;
    }[]>;
    upsertMetadata(id: string, items: Array<{
        key: AssetMetadataKey;
        value: object;
    }>): Promise<{
        key: AssetMetadataKey;
        value: object;
        updatedAt: Date;
    }[]>;
    getMetadataByKey(assetId: string, key: AssetMetadataKey): Promise<{
        key: AssetMetadataKey;
        value: object;
        updatedAt: Date;
    } | undefined>;
    deleteMetadataByKey(id: string, key: AssetMetadataKey): Promise<void>;
    create(asset: Insertable<AssetTable>): Promise<{
        id: string;
        type: AssetType;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        deletedAt: Date | null;
        status: AssetStatus;
        ownerId: string;
        isFavorite: boolean;
        stackId: string | null;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        duplicateId: string | null;
        visibility: AssetVisibility;
    }>;
    createAll(assets: Insertable<AssetTable>[]): Promise<{
        id: string;
        type: AssetType;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        deletedAt: Date | null;
        status: AssetStatus;
        ownerId: string;
        isFavorite: boolean;
        stackId: string | null;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        duplicateId: string | null;
        visibility: AssetVisibility;
    }[]>;
    getByDayOfYear(ownerIds: string[], { year, day, month }: YearMonthDay): Promise<{
        year: number;
        assets: {
            id: string;
            type: AssetType;
            updatedAt: Date;
            updateId: string;
            createdAt: Date;
            deletedAt: Date | null;
            status: AssetStatus;
            ownerId: string;
            isFavorite: boolean;
            stackId: string | null;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            duplicateId: string | null;
            visibility: AssetVisibility;
            exifInfo: {
                description: string;
                assetId: string;
                state: string | null;
                fileSizeInByte: number | null;
                make: string | null;
                model: string | null;
                exifImageWidth: number | null;
                exifImageHeight: number | null;
                orientation: string | null;
                dateTimeOriginal: Date | null;
                modifyDate: Date | null;
                lensModel: string | null;
                fNumber: number | null;
                focalLength: number | null;
                iso: number | null;
                latitude: number | null;
                longitude: number | null;
                city: string | null;
                country: string | null;
                fps: number | null;
                exposureTime: string | null;
                livePhotoCID: string | null;
                timeZone: string | null;
                projectionType: string | null;
                profileDescription: string | null;
                colorspace: string | null;
                bitsPerSample: number | null;
                autoStackId: string | null;
                rating: number | null;
                updatedAt: Date;
                updateId: string;
                lockedProperties: ("description" | "dateTimeOriginal" | "latitude" | "longitude" | "timeZone" | "rating")[] | null;
            };
        }[];
    }[]>;
    getByIds(ids: string[]): Promise<{
        id: string;
        type: AssetType;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        deletedAt: Date | null;
        status: AssetStatus;
        ownerId: string;
        isFavorite: boolean;
        stackId: string | null;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        duplicateId: string | null;
        visibility: AssetVisibility;
    }[]>;
    getByIdsWithAllRelationsButStacks(ids: string[]): Promise<{
        id: string;
        type: AssetType;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        deletedAt: Date | null;
        status: AssetStatus;
        ownerId: string;
        isFavorite: boolean;
        stackId: string | null;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        duplicateId: string | null;
        visibility: AssetVisibility;
        faces: {
            id: string;
            assetId: string;
            updatedAt: Date;
            updateId: string;
            deletedAt: Date | null;
            personId: string | null;
            imageWidth: number;
            imageHeight: number;
            boundingBoxX1: number;
            boundingBoxY1: number;
            boundingBoxX2: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            person: import("src/database").Person;
        }[];
        tags: {
            id: string;
            value: string;
            createdAt: Date;
            updatedAt: Date;
            color: string | null;
            parentId: string | null;
        }[];
        exifInfo: import("src/database").Exif | null;
    }[]>;
    deleteAll(ownerId: string): Promise<void>;
    getByDeviceIds(ownerId: string, deviceId: string, deviceAssetIds: string[]): Promise<string[]>;
    getByLibraryIdAndOriginalPath(libraryId: string, originalPath: string): Promise<{
        id: string;
        type: AssetType;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        deletedAt: Date | null;
        status: AssetStatus;
        ownerId: string;
        isFavorite: boolean;
        stackId: string | null;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        duplicateId: string | null;
        visibility: AssetVisibility;
    } | undefined>;
    getAllByDeviceId(ownerId: string, deviceId: string): Promise<string[]>;
    getLivePhotoCount(motionId: string): Promise<number>;
    getFileSamples(): Promise<{
        assetId: string;
        path: string;
    }[]>;
    getForCopy(id: string): Promise<{
        id: string;
        isFavorite: boolean;
        stackId: string | null;
        originalPath: string;
        files: {
            id: string;
            type: AssetFileType;
            path: string;
        }[];
    } | undefined>;
    getById(id: string, { exifInfo, faces, files, library, owner, smartSearch, stack, tags }?: GetByIdsRelations): Promise<{
        id: string;
        type: AssetType;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        deletedAt: Date | null;
        status: AssetStatus;
        ownerId: string;
        isFavorite: boolean;
        stackId: string | null;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        duplicateId: string | null;
        visibility: AssetVisibility;
        exifInfo?: import("src/database").Exif | null | undefined;
        faces?: {
            id: string;
            assetId: string;
            updatedAt: Date;
            updateId: string;
            deletedAt: Date | null;
            personId: string | null;
            imageWidth: number;
            imageHeight: number;
            boundingBoxX1: number;
            boundingBoxY1: number;
            boundingBoxX2: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
        }[] | undefined;
        library?: {
            id: string;
            name: string;
            updatedAt: Date;
            updateId: string;
            createdAt: Date;
            deletedAt: Date | null;
            ownerId: string;
            importPaths: string[];
            exclusionPatterns: string[];
            refreshedAt: Date | null;
        } | null | undefined;
        owner?: {
            id: string;
            name: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "asset" | "user", "avatarColor">;
            profileChangedAt: Date;
        } | null | undefined;
        smartSearch?: {
            assetId: string;
            embedding: string;
        } | null | undefined;
        stack?: Stack | null | undefined;
        files?: {
            id: string;
            type: AssetFileType;
            path: string;
        }[] | undefined;
        tags?: {
            id: string;
            value: string;
            createdAt: Date;
            updatedAt: Date;
            color: string | null;
            parentId: string | null;
        }[] | undefined;
    } | undefined>;
    updateAll(ids: string[], options: Updateable<AssetTable>): Promise<void>;
    updateByLibraryId(libraryId: string, options: Updateable<AssetTable>): Promise<void>;
    update(asset: Updateable<AssetTable> & {
        id: string;
    }): Promise<{
        id: string;
        type: AssetType;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        deletedAt: Date | null;
        status: AssetStatus;
        ownerId: string;
        isFavorite: boolean;
        stackId: string | null;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        duplicateId: string | null;
        visibility: AssetVisibility;
        exifInfo?: import("src/database").Exif | null | undefined;
        faces?: {
            id: string;
            assetId: string;
            updatedAt: Date;
            updateId: string;
            deletedAt: Date | null;
            personId: string | null;
            imageWidth: number;
            imageHeight: number;
            boundingBoxX1: number;
            boundingBoxY1: number;
            boundingBoxX2: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
        }[] | undefined;
        library?: {
            id: string;
            name: string;
            updatedAt: Date;
            updateId: string;
            createdAt: Date;
            deletedAt: Date | null;
            ownerId: string;
            importPaths: string[];
            exclusionPatterns: string[];
            refreshedAt: Date | null;
        } | null | undefined;
        owner?: {
            id: string;
            name: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "asset" | "user", "avatarColor">;
            profileChangedAt: Date;
        } | null | undefined;
        smartSearch?: {
            assetId: string;
            embedding: string;
        } | null | undefined;
        stack?: Stack | null | undefined;
        files?: {
            id: string;
            type: AssetFileType;
            path: string;
        }[] | undefined;
        tags?: {
            id: string;
            value: string;
            createdAt: Date;
            updatedAt: Date;
            color: string | null;
            parentId: string | null;
        }[] | undefined;
    } | {
        id: string;
        type: AssetType;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        deletedAt: Date | null;
        status: AssetStatus;
        ownerId: string;
        isFavorite: boolean;
        stackId: string | null;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        duplicateId: string | null;
        visibility: AssetVisibility;
        exifInfo: import("src/database").Exif | null;
        faces: {
            id: string;
            assetId: string;
            updatedAt: Date;
            updateId: string;
            deletedAt: Date | null;
            personId: string | null;
            imageWidth: number;
            imageHeight: number;
            boundingBoxX1: number;
            boundingBoxY1: number;
            boundingBoxX2: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            person: import("src/database").Person;
        }[];
    } | undefined>;
    remove(asset: {
        id: string;
    }): Promise<void>;
    getByChecksum({ ownerId, libraryId, checksum }: AssetGetByChecksumOptions): Promise<{
        id: string;
        type: AssetType;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        deletedAt: Date | null;
        status: AssetStatus;
        ownerId: string;
        isFavorite: boolean;
        stackId: string | null;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        duplicateId: string | null;
        visibility: AssetVisibility;
    } | undefined>;
    getByChecksums(userId: string, checksums: Buffer[]): Promise<{
        id: string;
        deletedAt: Date | null;
        checksum: Buffer<ArrayBufferLike>;
    }[]>;
    getUploadAssetIdByChecksum(ownerId: string, checksum: Buffer): Promise<string | undefined>;
    findLivePhotoMatch(options: LivePhotoSearchOptions): Promise<{
        id: string;
        ownerId: string;
    } | undefined>;
    getStatistics(ownerId: string, { visibility, isFavorite, isTrashed }: AssetStatsOptions): Promise<AssetStats>;
    getRandom(userIds: string[], take: number): Promise<{
        id: string;
        type: AssetType;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        deletedAt: Date | null;
        status: AssetStatus;
        ownerId: string;
        isFavorite: boolean;
        stackId: string | null;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        duplicateId: string | null;
        visibility: AssetVisibility;
        exifInfo: import("src/database").Exif | null;
    }[]>;
    getTimeBuckets(options: TimeBucketOptions): Promise<TimeBucketItem[]>;
    getTimeBucket(timeBucket: string, options: TimeBucketOptions, auth: AuthDto): Promise<{
        assets: string;
    }>;
    getAssetIdByCity(ownerId: string, { minAssetsPerField, maxFields }: AssetExploreFieldOptions): Promise<{
        fieldName: string;
        items: {
            value: string;
            data: string;
        }[];
    }>;
    getAllForUserFullSync(options: AssetFullSyncOptions): Promise<{
        id: string;
        type: AssetType;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        deletedAt: Date | null;
        status: AssetStatus;
        ownerId: string;
        isFavorite: boolean;
        stackId: string | null;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        duplicateId: string | null;
        visibility: AssetVisibility;
        exifInfo: import("src/database").Exif | null;
        stack: Stack | null;
    }[]>;
    getChangedDeltaSync(options: AssetDeltaSyncOptions): Promise<{
        id: string;
        type: AssetType;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        deletedAt: Date | null;
        status: AssetStatus;
        ownerId: string;
        isFavorite: boolean;
        stackId: string | null;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        duplicateId: string | null;
        visibility: AssetVisibility;
        exifInfo: import("src/database").Exif | null;
        stack: Stack | null;
    }[]>;
    upsertFile(file: Pick<Insertable<AssetFileTable>, 'assetId' | 'path' | 'type'>): Promise<void>;
    upsertFiles(files: Pick<Insertable<AssetFileTable>, 'assetId' | 'path' | 'type'>[]): Promise<void>;
    deleteFile({ assetId, type }: {
        assetId: string;
        type: AssetFileType;
    }): Promise<void>;
    deleteFiles(files: Pick<Selectable<AssetFileTable>, 'id'>[]): Promise<void>;
    detectOfflineExternalAssets(libraryId: string, importPaths: string[], exclusionPatterns: string[]): Promise<UpdateResult>;
    filterNewExternalAssetPaths(libraryId: string, paths: string[]): Promise<string[]>;
    getLibraryAssetCount(libraryId: string): Promise<number>;
}
export {};
