"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CryptoRepository = void 0;
const common_1 = require("@nestjs/common");
const bcrypt_1 = require("bcrypt");
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const node_crypto_1 = require("node:crypto");
const node_fs_1 = require("node:fs");
let CryptoRepository = class CryptoRepository {
    randomUUID() {
        return (0, node_crypto_1.randomUUID)();
    }
    randomBytes(size) {
        return (0, node_crypto_1.randomBytes)(size);
    }
    hashBcrypt(data, saltOrRounds) {
        return (0, bcrypt_1.hash)(data, saltOrRounds);
    }
    compareBcrypt(data, encrypted) {
        return (0, bcrypt_1.compareSync)(data, encrypted);
    }
    hashSha256(value) {
        return (0, node_crypto_1.createHash)('sha256').update(value).digest('base64');
    }
    verifySha256(value, encryptedValue, publicKey) {
        const publicKeyBuffer = Buffer.from(publicKey, 'base64');
        const cryptoPublicKey = (0, node_crypto_1.createPublicKey)({
            key: publicKeyBuffer,
            type: 'spki',
            format: 'pem',
        });
        const verifier = (0, node_crypto_1.createVerify)('SHA256');
        verifier.update(value);
        verifier.end();
        const encryptedValueBuffer = Buffer.from(encryptedValue, 'base64');
        return verifier.verify(cryptoPublicKey, encryptedValueBuffer);
    }
    hashSha1(value) {
        return (0, node_crypto_1.createHash)('sha1').update(value).digest();
    }
    hashFile(filepath) {
        return new Promise((resolve, reject) => {
            const hash = (0, node_crypto_1.createHash)('sha1');
            const stream = (0, node_fs_1.createReadStream)(filepath);
            stream.on('error', (error) => reject(error));
            stream.on('data', (chunk) => hash.update(chunk));
            stream.on('end', () => resolve(hash.digest()));
        });
    }
    randomBytesAsText(bytes) {
        return (0, node_crypto_1.randomBytes)(bytes).toString('base64').replaceAll(/\W/g, '');
    }
    signJwt(payload, secret, options) {
        return jsonwebtoken_1.default.sign(payload, secret, { algorithm: 'HS256', ...options });
    }
    verifyJwt(token, secret) {
        return jsonwebtoken_1.default.verify(token, secret, { algorithms: ['HS256'] });
    }
};
exports.CryptoRepository = CryptoRepository;
exports.CryptoRepository = CryptoRepository = __decorate([
    (0, common_1.Injectable)()
], CryptoRepository);
//# sourceMappingURL=crypto.repository.js.map