import { BinaryField, Tags } from 'exiftool-vendored';
import { LoggingRepository } from 'src/repositories/logging.repository';
interface ExifDuration {
    Value: number;
    Scale?: number;
}
type StringOrNumber = string | number;
type TagsWithWrongTypes = 'FocalLength' | 'Duration' | 'Description' | 'ImageDescription' | 'RegionInfo' | 'TagsList' | 'Keywords' | 'HierarchicalSubject' | 'ISO';
export interface ImmichTags extends Omit<Tags, TagsWithWrongTypes> {
    ContentIdentifier?: string;
    MotionPhoto?: number;
    MotionPhotoVersion?: number;
    MotionPhotoPresentationTimestampUs?: number;
    MediaGroupUUID?: string;
    ImagePixelDepth?: string;
    FocalLength?: number;
    Duration?: number | string | ExifDuration;
    EmbeddedVideoType?: string;
    EmbeddedVideoFile?: BinaryField;
    MotionPhotoVideo?: BinaryField;
    TagsList?: StringOrNumber[];
    HierarchicalSubject?: StringOrNumber[];
    Keywords?: StringOrNumber | StringOrNumber[];
    ISO?: number | number[];
    Description?: StringOrNumber;
    ImageDescription?: StringOrNumber;
    RegionInfo?: {
        AppliedToDimensions: {
            W: number;
            H: number;
            Unit: string;
        };
        RegionList: {
            Area: {
                X: number;
                Y: number;
                W: number;
                H: number;
                Unit: string;
            };
            Rotation?: number;
            Type?: string;
            Name?: string;
        }[];
    };
    Device?: {
        Manufacturer?: string;
        ModelName?: string;
    };
    AndroidMake?: string;
    AndroidModel?: string;
}
export declare class MetadataRepository {
    private logger;
    private exiftool;
    constructor(logger: LoggingRepository);
    setMaxConcurrency(concurrency: number): void;
    teardown(): Promise<void>;
    readTags(path: string): Promise<ImmichTags>;
    extractBinaryTag(path: string, tagName: string): Promise<Buffer>;
    writeTags(path: string, tags: Partial<Tags>): Promise<void>;
}
export {};
