"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationRepository = void 0;
const kysely_1 = require("kysely");
const luxon_1 = require("luxon");
const nestjs_kysely_1 = require("nestjs-kysely");
const database_1 = require("../database");
const decorators_1 = require("../decorators");
const notification_dto_1 = require("../dtos/notification.dto");
let NotificationRepository = class NotificationRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    cleanup() {
        return this.db
            .deleteFrom('notification')
            .where((eb) => eb.or([
            eb.and([eb('deletedAt', 'is not', null), eb('deletedAt', '<', luxon_1.DateTime.now().minus({ days: 3 }).toJSDate())]),
            eb.and([
                eb('readAt', '>', luxon_1.DateTime.now().minus({ days: 2 }).toJSDate()),
                eb('createdAt', '<', luxon_1.DateTime.now().minus({ days: 15 }).toJSDate()),
            ]),
            eb.and([
                eb('readAt', '=', null),
                eb('createdAt', '<', luxon_1.DateTime.now().minus({ days: 30 }).toJSDate()),
            ]),
        ]))
            .execute();
    }
    search(userId, dto) {
        return this.db
            .selectFrom('notification')
            .select(database_1.columns.notification)
            .where((qb) => qb.and({
            userId,
            id: dto.id,
            level: dto.level,
            type: dto.type,
            readAt: dto.unread ? null : undefined,
        }))
            .where('deletedAt', 'is', null)
            .orderBy('createdAt', 'desc')
            .execute();
    }
    create(notification) {
        return this.db
            .insertInto('notification')
            .values(notification)
            .returning(database_1.columns.notification)
            .executeTakeFirstOrThrow();
    }
    get(id) {
        return this.db
            .selectFrom('notification')
            .select(database_1.columns.notification)
            .where('id', '=', id)
            .where('deletedAt', 'is not', null)
            .executeTakeFirst();
    }
    update(id, notification) {
        return this.db
            .updateTable('notification')
            .set(notification)
            .where('deletedAt', 'is', null)
            .where('id', '=', id)
            .returning(database_1.columns.notification)
            .executeTakeFirstOrThrow();
    }
    async updateAll(ids, notification) {
        await this.db.updateTable('notification').set(notification).where('id', 'in', ids).execute();
    }
    async delete(id) {
        await this.db
            .updateTable('notification')
            .set({ deletedAt: luxon_1.DateTime.now().toJSDate() })
            .where('id', '=', id)
            .execute();
    }
    async deleteAll(ids) {
        await this.db
            .updateTable('notification')
            .set({ deletedAt: luxon_1.DateTime.now().toJSDate() })
            .where('id', 'in', ids)
            .execute();
    }
};
exports.NotificationRepository = NotificationRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, {}] }, { name: 'unread', params: [decorators_1.DummyValue.UUID, { unread: true }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, notification_dto_1.NotificationSearchDto]),
    __metadata("design:returntype", void 0)
], NotificationRepository.prototype, "search", null);
exports.NotificationRepository = NotificationRepository = __decorate([
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], NotificationRepository);
//# sourceMappingURL=notification.repository.js.map