import { Kysely } from 'kysely';
import { PluginManifestDto } from 'src/dtos/plugin-manifest.dto';
import { DB } from 'src/schema';
export declare class PluginRepository {
    private db;
    constructor(db: Kysely<DB>);
    loadPlugin(manifest: PluginManifestDto, basePath: string): Promise<{
        plugin: {
            version: string;
            id: string;
            description: string;
            title: string;
            name: string;
            updatedAt: Date;
            createdAt: Date;
            author: string;
            wasmPath: string;
        };
        filters: {
            id: string;
            description: string;
            title: string;
            supportedContexts: import("../enum").PluginContext[];
            pluginId: string;
            methodName: string;
            schema: import("../types/plugin-schema.types").JSONSchema | null;
        }[];
        actions: {
            id: string;
            description: string;
            title: string;
            supportedContexts: import("../enum").PluginContext[];
            pluginId: string;
            methodName: string;
            schema: import("../types/plugin-schema.types").JSONSchema | null;
        }[];
    }>;
    readDirectory(path: string): Promise<import("fs").Dirent<string>[]>;
    getPlugin(id: string): Promise<{
        id: string;
        name: string;
        title: string;
        description: string;
        author: string;
        version: string;
        wasmPath: string;
        createdAt: Date;
        updatedAt: Date;
        filters: {
            version: string;
            id: string;
            description: string;
            title: string;
            name: string;
            updatedAt: Date;
            createdAt: Date;
            author: string;
            wasmPath: string;
            supportedContexts: import("../enum").PluginContext[];
            pluginId: string;
            methodName: string;
            schema: import("../types/plugin-schema.types").JSONSchema | null;
        }[];
        actions: {
            version: string;
            id: string;
            description: string;
            title: string;
            name: string;
            updatedAt: Date;
            createdAt: Date;
            author: string;
            wasmPath: string;
            supportedContexts: import("../enum").PluginContext[];
            pluginId: string;
            methodName: string;
            schema: import("../types/plugin-schema.types").JSONSchema | null;
        }[];
    } | undefined>;
    getPluginByName(name: string): Promise<{
        id: string;
        name: string;
        title: string;
        description: string;
        author: string;
        version: string;
        wasmPath: string;
        createdAt: Date;
        updatedAt: Date;
        filters: {
            version: string;
            id: string;
            description: string;
            title: string;
            name: string;
            updatedAt: Date;
            createdAt: Date;
            author: string;
            wasmPath: string;
            supportedContexts: import("../enum").PluginContext[];
            pluginId: string;
            methodName: string;
            schema: import("../types/plugin-schema.types").JSONSchema | null;
        }[];
        actions: {
            version: string;
            id: string;
            description: string;
            title: string;
            name: string;
            updatedAt: Date;
            createdAt: Date;
            author: string;
            wasmPath: string;
            supportedContexts: import("../enum").PluginContext[];
            pluginId: string;
            methodName: string;
            schema: import("../types/plugin-schema.types").JSONSchema | null;
        }[];
    } | undefined>;
    getAllPlugins(): Promise<{
        id: string;
        name: string;
        title: string;
        description: string;
        author: string;
        version: string;
        wasmPath: string;
        createdAt: Date;
        updatedAt: Date;
        filters: {
            version: string;
            id: string;
            description: string;
            title: string;
            name: string;
            updatedAt: Date;
            createdAt: Date;
            author: string;
            wasmPath: string;
            supportedContexts: import("../enum").PluginContext[];
            pluginId: string;
            methodName: string;
            schema: import("../types/plugin-schema.types").JSONSchema | null;
        }[];
        actions: {
            version: string;
            id: string;
            description: string;
            title: string;
            name: string;
            updatedAt: Date;
            createdAt: Date;
            author: string;
            wasmPath: string;
            supportedContexts: import("../enum").PluginContext[];
            pluginId: string;
            methodName: string;
            schema: import("../types/plugin-schema.types").JSONSchema | null;
        }[];
    }[]>;
    getFilter(id: string): Promise<{
        id: string;
        description: string;
        title: string;
        supportedContexts: import("../enum").PluginContext[];
        pluginId: string;
        methodName: string;
        schema: import("../types/plugin-schema.types").JSONSchema | null;
    } | undefined>;
    getFiltersByPlugin(pluginId: string): Promise<{
        id: string;
        description: string;
        title: string;
        supportedContexts: import("../enum").PluginContext[];
        pluginId: string;
        methodName: string;
        schema: import("../types/plugin-schema.types").JSONSchema | null;
    }[]>;
    getAction(id: string): Promise<{
        id: string;
        description: string;
        title: string;
        supportedContexts: import("../enum").PluginContext[];
        pluginId: string;
        methodName: string;
        schema: import("../types/plugin-schema.types").JSONSchema | null;
    } | undefined>;
    getActionsByPlugin(pluginId: string): Promise<{
        id: string;
        description: string;
        title: string;
        supportedContexts: import("../enum").PluginContext[];
        pluginId: string;
        methodName: string;
        schema: import("../types/plugin-schema.types").JSONSchema | null;
    }[]>;
}
