"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SyncCheckpointRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
let SyncCheckpointRepository = class SyncCheckpointRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    getAll(sessionId) {
        return this.db
            .selectFrom('session_sync_checkpoint')
            .select(['type', 'ack'])
            .where('sessionId', '=', sessionId)
            .execute();
    }
    upsertAll(items) {
        return this.db
            .insertInto('session_sync_checkpoint')
            .values(items)
            .onConflict((oc) => oc.columns(['sessionId', 'type']).doUpdateSet((eb) => ({
            ack: eb.ref('excluded.ack'),
        })))
            .execute();
    }
    deleteAll(sessionId, types) {
        return this.db
            .deleteFrom('session_sync_checkpoint')
            .where('sessionId', '=', sessionId)
            .$if(!!types, (qb) => qb.where('type', 'in', types))
            .execute();
    }
    getNow() {
        return this.db
            .selectNoFrom((eb) => [
            eb.fn('immich_uuid_v7', [kysely_1.sql.raw("now() - interval '1 millisecond'")]).as('nowId'),
        ])
            .executeTakeFirstOrThrow();
    }
};
exports.SyncCheckpointRepository = SyncCheckpointRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SyncCheckpointRepository.prototype, "getAll", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", void 0)
], SyncCheckpointRepository.prototype, "deleteAll", null);
__decorate([
    (0, decorators_1.GenerateSql)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SyncCheckpointRepository.prototype, "getNow", null);
exports.SyncCheckpointRepository = SyncCheckpointRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], SyncCheckpointRepository);
//# sourceMappingURL=sync-checkpoint.repository.js.map