"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var TagRepository_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const database_1 = require("../database");
const decorators_1 = require("../decorators");
const logging_repository_1 = require("./logging.repository");
let TagRepository = TagRepository_1 = class TagRepository {
    db;
    logger;
    constructor(db, logger) {
        this.db = db;
        this.logger = logger;
        this.logger.setContext(TagRepository_1.name);
    }
    get(id) {
        return this.db.selectFrom('tag').select(database_1.columns.tag).where('id', '=', id).executeTakeFirst();
    }
    getByValue(userId, value) {
        return this.db
            .selectFrom('tag')
            .select(database_1.columns.tag)
            .where('userId', '=', userId)
            .where('value', '=', value)
            .executeTakeFirst();
    }
    async upsertValue({ userId, value, parentId: _parentId }) {
        const parentId = _parentId ?? null;
        return this.db.transaction().execute(async (tx) => {
            const tag = await this.db
                .insertInto('tag')
                .values({ userId, value, parentId })
                .onConflict((oc) => oc.columns(['userId', 'value']).doUpdateSet({ parentId }))
                .returning(database_1.columns.tag)
                .executeTakeFirstOrThrow();
            await tx
                .insertInto('tag_closure')
                .values({ id_ancestor: tag.id, id_descendant: tag.id })
                .onConflict((oc) => oc.doNothing())
                .execute();
            if (parentId) {
                await tx
                    .insertInto('tag_closure')
                    .columns(['id_ancestor', 'id_descendant'])
                    .expression(this.db
                    .selectFrom('tag_closure')
                    .select(['id_ancestor', kysely_1.sql.raw(`'${tag.id}'`).as('id_descendant')])
                    .where('id_descendant', '=', parentId))
                    .onConflict((oc) => oc.doNothing())
                    .execute();
            }
            return tag;
        });
    }
    getAll(userId) {
        return this.db.selectFrom('tag').select(database_1.columns.tag).where('userId', '=', userId).orderBy('value').execute();
    }
    create(tag) {
        return this.db.insertInto('tag').values(tag).returningAll().executeTakeFirstOrThrow();
    }
    update(id, dto) {
        return this.db.updateTable('tag').set(dto).where('id', '=', id).returningAll().executeTakeFirstOrThrow();
    }
    async delete(id) {
        await this.db.deleteFrom('tag').where('id', '=', id).execute();
    }
    async getAssetIds(tagId, assetIds) {
        if (assetIds.length === 0) {
            return new Set();
        }
        const results = await this.db
            .selectFrom('tag_asset')
            .select(['assetId as assetId'])
            .where('tagId', '=', tagId)
            .where('assetId', 'in', assetIds)
            .execute();
        return new Set(results.map(({ assetId }) => assetId));
    }
    async addAssetIds(tagId, assetIds) {
        if (assetIds.length === 0) {
            return;
        }
        await this.db
            .insertInto('tag_asset')
            .values(assetIds.map((assetId) => ({ tagId, assetId })))
            .execute();
    }
    async removeAssetIds(tagId, assetIds) {
        if (assetIds.length === 0) {
            return;
        }
        await this.db.deleteFrom('tag_asset').where('tagId', '=', tagId).where('assetId', 'in', assetIds).execute();
    }
    upsertAssetIds(items) {
        if (items.length === 0) {
            return Promise.resolve([]);
        }
        return this.db
            .insertInto('tag_asset')
            .values(items)
            .onConflict((oc) => oc.doNothing())
            .returningAll()
            .execute();
    }
    replaceAssetTags(assetId, tagIds) {
        return this.db.transaction().execute(async (tx) => {
            await tx.deleteFrom('tag_asset').where('assetId', '=', assetId).execute();
            if (tagIds.length === 0) {
                return;
            }
            return tx
                .insertInto('tag_asset')
                .values(tagIds.map((tagId) => ({ tagId, assetId })))
                .onConflict((oc) => oc.doNothing())
                .returningAll()
                .execute();
        });
    }
    async deleteEmptyTags() {
        const result = await this.db
            .deleteFrom('tag')
            .where(({ not, exists, selectFrom }) => not(exists(selectFrom('tag_closure')
            .whereRef('tag.id', '=', 'tag_closure.id_ancestor')
            .innerJoin('tag_asset', 'tag_closure.id_descendant', 'tag_asset.tagId'))))
            .executeTakeFirst();
        const deletedRows = Number(result.numDeletedRows);
        if (deletedRows > 0) {
            this.logger.log(`Deleted ${deletedRows} empty tags`);
        }
    }
};
exports.TagRepository = TagRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], TagRepository.prototype, "get", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.STRING] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], TagRepository.prototype, "getByValue", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ userId: decorators_1.DummyValue.UUID, value: decorators_1.DummyValue.STRING, parentId: decorators_1.DummyValue.UUID }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], TagRepository.prototype, "upsertValue", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], TagRepository.prototype, "getAll", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ userId: decorators_1.DummyValue.UUID, color: decorators_1.DummyValue.STRING, value: decorators_1.DummyValue.STRING }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], TagRepository.prototype, "create", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, { color: decorators_1.DummyValue.STRING }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], TagRepository.prototype, "update", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], TagRepository.prototype, "delete", null);
__decorate([
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, [decorators_1.DummyValue.UUID]] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", Promise)
], TagRepository.prototype, "getAssetIds", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, [decorators_1.DummyValue.UUID]] }),
    (0, decorators_1.Chunked)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", Promise)
], TagRepository.prototype, "addAssetIds", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, [decorators_1.DummyValue.UUID]] }),
    (0, decorators_1.Chunked)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", Promise)
], TagRepository.prototype, "removeAssetIds", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[{ assetId: decorators_1.DummyValue.UUID, tagIds: decorators_1.DummyValue.UUID }]] }),
    (0, decorators_1.Chunked)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], TagRepository.prototype, "upsertAssetIds", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, [decorators_1.DummyValue.UUID]] }),
    (0, decorators_1.Chunked)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", void 0)
], TagRepository.prototype, "replaceAssetTags", null);
exports.TagRepository = TagRepository = TagRepository_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely,
        logging_repository_1.LoggingRepository])
], TagRepository);
//# sourceMappingURL=tag.repository.js.map