"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
async function up(db) {
    await (0, kysely_1.sql) `ALTER TABLE "albums_shared_users_users" ADD "createId" uuid NOT NULL DEFAULT immich_uuid_v7();`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "albums_shared_users_users" ADD "createdAt" timestamp with time zone NOT NULL DEFAULT now();`.execute(db);
    await (0, kysely_1.sql) `CREATE INDEX "IDX_album_users_create_id" ON "albums_shared_users_users" ("createId")`.execute(db);
    await (0, kysely_1.sql) `CREATE INDEX "IDX_partners_create_id" ON "partners" ("createId")`.execute(db);
}
async function down(db) {
    await (0, kysely_1.sql) `DROP INDEX "IDX_partners_create_id";`.execute(db);
    await (0, kysely_1.sql) `DROP INDEX "IDX_album_users_create_id";`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "albums_shared_users_users" DROP COLUMN "createId";`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "albums_shared_users_users" DROP COLUMN "createdAt";`.execute(db);
}
//# sourceMappingURL=1750189909087-AddAlbumUserCreateFields.js.map